/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.traces;

import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.TraceValidator;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class NamedTraceValidator
implements IValidator {
    private static final String ERROR = "Please enter a correct identifier.";
    private TraceValidator traceValidator = new TraceValidator();
    private String identifier = "";
    private String traces = "";

    public IStatus validate(Object value) {
        String message = null;
        if (value == null) {
            message = ERROR;
        } else if (value instanceof String) {
            String traces;
            String[] values = value.toString().trim().split("\\|");
            String identifier = values.length > 0 ? values[0].trim() : "";
            String string = traces = values.length > 1 ? values[1].trim() : "";
            if ("".equals(identifier)) {
                message = ERROR;
            } else {
                this.identifier = identifier;
                IStatus status = this.traceValidator.validate(traces);
                if (status.isOK()) {
                    this.traces = traces;
                } else {
                    message = status.getMessage();
                }
            }
        } else {
            message = ERROR;
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTraces() {
        return this.traces;
    }
}

