/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMarkedSignal;
import org.eclipse.chemclipse.model.core.IMarkedSignals;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.ChromatogramSelection;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.listener.PeakTracesOffsetListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.DisplayType;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.Derivative;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanDataSupport;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class PeakTracesUI
extends ScrollableChart {
    private final ChromatogramChartSupport chromatogramChartSupport = new ChromatogramChartSupport();
    private final PeakChartSupport peakChartSupport = new PeakChartSupport();
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private List<Integer> traces = new ArrayList<Integer>();
    private int selectedTrace = 0;
    private IPeak peak = null;
    private PeakTracesOffsetListener peakTracesOffsetListener = new PeakTracesOffsetListener(this.getBaseChart());
    private ScanDataSupport scanDataSupport = new ScanDataSupport();

    public PeakTracesUI() {
        this.modifyChart();
    }

    public PeakTracesUI(Composite parent, int style) {
        super(parent, style);
        this.modifyChart();
    }

    public List<Integer> getTraces() {
        return this.traces;
    }

    public void setSelectedTrace(int selectedTrace) {
        this.selectedTrace = selectedTrace;
    }

    public void setInput(IPeak peak) {
        this.peak = peak;
        this.updateChart();
    }

    public void updateChart() {
        this.modifyChart(this.peak);
        this.deleteSeries();
        this.traces.clear();
        this.peakTracesOffsetListener.setOffsetRetentionTime(0);
        ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
        if (this.peak instanceof IChromatogramPeakMSD) {
            IChromatogramPeakMSD chromatogramPeak = (IChromatogramPeakMSD)this.peak;
            IChromatogramMSD chromatogram = chromatogramPeak.getChromatogram();
            IPeakModelMSD peakModel = chromatogramPeak.getPeakModel();
            int offsetRetentionTime = this.preferenceStore.getInt("peakTracesOffsetRetentionTime");
            this.peakTracesOffsetListener.setOffsetRetentionTime(offsetRetentionTime);
            int startRetentionTime = peakModel.getStartRetentionTime() - offsetRetentionTime;
            int stopRetentionTime = peakModel.getStopRetentionTime() + offsetRetentionTime;
            IPeakMassSpectrum massSpectrum = peakModel.getPeakMassSpectrum();
            ChromatogramSelection chromatogramSelection = new ChromatogramSelection((IChromatogram)chromatogram);
            chromatogramSelection.setRangeRetentionTime(startRetentionTime, stopRetentionTime, false);
            IColorScheme colors = Colors.getColorScheme((String)this.preferenceStore.getString("colorSchemePeakTraces"));
            this.extractTraces((IScanMSD)massSpectrum);
            for (Integer trace : this.traces) {
                MarkedIons markedIons = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
                markedIons.add(new int[]{trace});
                ILineSeriesData lineSeriesData = this.chromatogramChartSupport.getLineSeriesData((IChromatogramSelection<?, ?>)chromatogramSelection, Integer.toString(trace), DisplayType.SIC, Derivative.NONE, colors.getColor(), (IMarkedSignals<? extends IMarkedSignal>)markedIons, false);
                ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                if (trace == this.selectedTrace) {
                    lineSeriesSettings.setLineWidth(2);
                }
                lineSeriesDataList.add(lineSeriesData);
                colors.incrementColor();
            }
        } else if (this.peak != null) {
            lineSeriesDataList.add(this.peakChartSupport.getPeak(this.peak, false, false, Colors.RED, "Peak"));
        }
        this.addLineSeriesData(lineSeriesDataList);
    }

    private void extractTraces(IScanMSD scanMSD) {
        ArrayList ions = new ArrayList(scanMSD.getIons());
        Collections.sort(ions, (i1, i2) -> Float.compare(i2.getAbundance(), i1.getAbundance()));
        int maxDisplayTraces = this.preferenceStore.getInt("maxDisplayPeakTraces");
        for (IIon ion : ions) {
            int trace = AbstractIon.getIon((double)ion.getIon());
            if (!this.traces.contains(trace)) {
                this.traces.add(trace);
            }
            if (this.traces.size() >= maxDisplayTraces) break;
        }
        Collections.sort(this.traces);
    }

    private void modifyChart() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setCreateMenu(true);
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setRestrictZoom(true);
        rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtendMinY(0.0);
        rangeRestriction.setExtendMaxY(0.1);
        BaseChart baseChart = this.getBaseChart();
        IPlotArea plotArea = baseChart.getPlotArea();
        plotArea.addCustomPaintListener((ICustomPaintListener)this.peakTracesOffsetListener);
        this.applySettings(chartSettings);
    }

    private void modifyChart(IPeak peak) {
        IChartSettings chartSettings = this.getChartSettings();
        if (peak instanceof IPeakMSD) {
            this.scanDataSupport.setDataTypeMSD(chartSettings);
        } else if (peak instanceof IPeakCSD) {
            this.scanDataSupport.setDataTypeCSD(chartSettings);
        } else if (peak instanceof IPeakWSD) {
            this.scanDataSupport.setDataTypeWSD(chartSettings);
        }
        this.applySettings(chartSettings);
    }

    private void addLineSeriesData(List<ILineSeriesData> lineSeriesDataList) {
        if (lineSeriesDataList != null && lineSeriesDataList.size() > 0) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            for (ILineSeriesData lineSeriesData : lineSeriesDataList) {
                try {
                    ISeriesData seriesData = lineSeriesData.getSeriesData();
                    ISeriesData optimizedSeriesData = this.calculateSeries(seriesData);
                    ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                    lineSeriesSettings.getSeriesSettingsHighlight();
                    ILineSeries lineSeries = (ILineSeries)this.createSeries(optimizedSeriesData, (ISeriesSettings)lineSeriesSettings);
                    baseChart.applyLineSeriesSettings(lineSeries, lineSeriesSettings);
                }
                catch (SeriesException seriesException) {
                    // empty catch block
                }
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }
}

