/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.eclipse.chemclipse.model.core.IComplexSignalMeasurement;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.detector.IMeasurementPeakDetector;
import org.eclipse.chemclipse.model.filter.IMeasurementFilter;
import org.eclipse.chemclipse.nmr.model.core.FIDMeasurement;
import org.eclipse.chemclipse.nmr.model.core.SpectrumMeasurement;
import org.eclipse.chemclipse.nmr.model.selection.DataNMRSelection;
import org.eclipse.chemclipse.nmr.model.selection.IDataNMRSelection;
import org.eclipse.chemclipse.processing.ProcessorFactory;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.Filtered;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.actions.IMeasurementFilterAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class NMRMeasurementsUI
implements Observer {
    private static final Image IMAGE_FREQUENCY = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/scan-nmr.gif", "16x16");
    private static final Image IMAGE_FID = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/scan-fid.png", "16x16");
    private static final TreeNode[] EMPTY = new TreeNode[0];
    private TreeViewer treeViewer;
    private DataNMRSelection selection;
    private ProcessorFactory filterFactory;
    private ProcessSupplierContext processSupplierContext;

    public NMRMeasurementsUI(Composite parent, ProcessorFactory filterFactory, ProcessSupplierContext processSupplierContext) {
        this.filterFactory = filterFactory;
        this.processSupplierContext = processSupplierContext;
        this.treeViewer = new TreeViewer(parent, 68356);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                if (element instanceof TreeNode) {
                    return element.hashCode();
                }
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (a instanceof TreeNode) {
                    a = ((TreeNode)a).getValue();
                }
                if (b instanceof TreeNode) {
                    b = ((TreeNode)b).getValue();
                }
                return a.equals(b);
            }
        });
        NMRMeasurementsUI.createColumn(this.treeViewer, "Measurements", 300, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if ((element = NMRMeasurementsUI.getMeasurement(element)) instanceof IMeasurement) {
                    return ((IMeasurement)element).getDataName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if ((element = NMRMeasurementsUI.getMeasurement(element)) instanceof FIDMeasurement) {
                    return IMAGE_FID;
                }
                if (element instanceof SpectrumMeasurement) {
                    return IMAGE_FREQUENCY;
                }
                return super.getImage(element);
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IComplexSignalMeasurement measurement = NMRMeasurementsUI.getMeasurement(NMRMeasurementsUI.this.treeViewer.getStructuredSelection().getFirstElement());
                if (NMRMeasurementsUI.this.selection != null) {
                    NMRMeasurementsUI.this.selection.setActiveMeasurement(measurement);
                }
            }
        });
        this.createContextMenu();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void createContextMenu() {
        MenuManager contextMenu = new MenuManager("ViewerContextMenu");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Set<IComplexSignalMeasurement<?>> measurements = Collections.singleton(NMRMeasurementsUI.this.selection.getMeasurement());
                this.addFilter(mgr, measurements);
                mgr.add((IContributionItem)new Separator());
                this.addDetectors(mgr, measurements);
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)new DeleteAction());
            }

            private void addDetectors(IMenuManager mgr, final Set<IComplexSignalMeasurement<?>> measurements) {
                Collection detectors = NMRMeasurementsUI.this.filterFactory.getProcessors(ProcessorFactory.genericClass(IMeasurementPeakDetector.class), new BiPredicate<IMeasurementPeakDetector<?>, Map<String, ?>>(){

                    @Override
                    public boolean test(IMeasurementPeakDetector<?> detector, Map<String, ?> u) {
                        return detector.acceptsIMeasurements((Collection)measurements);
                    }
                });
                for (final IMeasurementPeakDetector peakDetector : detectors) {
                    mgr.add((IAction)new Action(){

                        public String getText() {
                            return peakDetector.getName();
                        }

                        public void run() {
                            Map peaks = peakDetector.detectIMeasurementPeaks((Collection)measurements, null, (MessageConsumer)new DefaultProcessingResult(), null);
                            for (Map.Entry entries : peaks.entrySet()) {
                                ((IComplexSignalMeasurement)entries.getKey()).addMeasurementResult((IMeasurementResult)entries.getValue());
                            }
                            NMRMeasurementsUI.this.selection.setChanged();
                            NMRMeasurementsUI.this.selection.notifyObservers((Object)IDataNMRSelection.ChangeType.SELECTION_CHANGED);
                        }
                    });
                }
            }

            private void addFilter(IMenuManager mgr, Set<IComplexSignalMeasurement<?>> measurements) {
                Collection filters = NMRMeasurementsUI.this.filterFactory.getProcessors(ProcessorFactory.genericClass(IMeasurementFilter.class), (filter, properties) -> filter.acceptsIMeasurements((Collection)measurements));
                Consumer<Collection<? extends IMeasurement>> consumer = new Consumer<Collection<? extends IMeasurement>>(){

                    @Override
                    public void accept(Collection<? extends IMeasurement> filtered) {
                        for (IMeasurement iMeasurement : filtered) {
                            if (!(iMeasurement instanceof IComplexSignalMeasurement) || NMRMeasurementsUI.this.selection == null) continue;
                            NMRMeasurementsUI.this.selection.addMeasurement((IComplexSignalMeasurement)iMeasurement);
                        }
                    }
                };
                for (IMeasurementFilter filter2 : filters) {
                    IMeasurementFilterAction action = new IMeasurementFilterAction(filter2, measurements, consumer, NMRMeasurementsUI.this.processSupplierContext);
                    mgr.add((IAction)action);
                }
            }
        });
        Menu menu = contextMenu.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
    }

    private static void remove(TreeNode node, DataNMRSelection selection) {
        Object value;
        TreeNode[] children = node.getChildren();
        if (children != null) {
            TreeNode[] treeNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode child = treeNodeArray[n2];
                NMRMeasurementsUI.remove(child, selection);
                ++n2;
            }
        }
        if ((value = node.getValue()) instanceof IComplexSignalMeasurement && value instanceof Filtered) {
            selection.removeMeasurement((IComplexSignalMeasurement)value);
        }
    }

    private static IComplexSignalMeasurement<?> getMeasurement(Object value) {
        if (value instanceof TreeNode) {
            return NMRMeasurementsUI.getMeasurement(((TreeNode)value).getValue());
        }
        if (value instanceof IComplexSignalMeasurement) {
            return (IComplexSignalMeasurement)value;
        }
        return null;
    }

    public void update(DataNMRSelection selection) {
        if (this.selection != null) {
            this.selection.removeObserver((Observer)this);
        }
        this.selection = selection;
        this.updateTree();
        selection.addObserver((Observer)this);
    }

    public void updateTree() {
        this.treeViewer.setInput((Object)this.createTreeNodes(this.selection).toArray(EMPTY));
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        IComplexSignalMeasurement measurement = this.selection.getMeasurement();
        if (measurement == null) {
            this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)measurement));
        }
    }

    public IComplexSignalMeasurement<?> getSelection() {
        return NMRMeasurementsUI.getMeasurement(this.treeViewer.getStructuredSelection().getFirstElement());
    }

    private List<TreeNode> createTreeNodes(DataNMRSelection selection) {
        ArrayList measurements = new ArrayList(Arrays.asList(selection.getMeasurements()));
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        Iterator iterator = measurements.iterator();
        while (iterator.hasNext()) {
            IComplexSignalMeasurement measurement = (IComplexSignalMeasurement)iterator.next();
            if (measurement instanceof Filtered) continue;
            iterator.remove();
            TreeNode treeNode = new TreeNode((Object)measurement);
            list.add(treeNode);
        }
        for (TreeNode treeNode : list) {
            this.findChildren(treeNode, measurements);
        }
        return list;
    }

    private void findChildren(TreeNode parent, Collection<IComplexSignalMeasurement<?>> measurements) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        Iterator<IComplexSignalMeasurement<?>> iterator = measurements.iterator();
        while (iterator.hasNext()) {
            Filtered filtered;
            IComplexSignalMeasurement<?> measurement = iterator.next();
            if (!(measurement instanceof Filtered) || (filtered = (Filtered)measurement).getFilterContext().getFilteredObject() != parent.getValue()) continue;
            iterator.remove();
            TreeNode childNode = new TreeNode((Object)filtered);
            childNode.setParent(parent);
            children.add(childNode);
        }
        for (TreeNode childNode : children) {
            this.findChildren(childNode, measurements);
        }
        parent.setChildren(children.toArray(EMPTY));
    }

    private static TreeViewerColumn createColumn(TreeViewer treeViewer, String text, int width, CellLabelProvider labelProvider) {
        TreeViewerColumn column = new TreeViewerColumn(treeViewer, 0);
        column.getColumn().setText(text);
        column.getColumn().setWidth(width);
        column.setLabelProvider(labelProvider);
        return column;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == IDataNMRSelection.ChangeType.NEW_ITEM || arg == IDataNMRSelection.ChangeType.REMOVED_ITEM) {
            Display.getDefault().asyncExec(this::updateTree);
        }
    }

    private final class DeleteAction
    extends Action {
        public DeleteAction() {
            this.setText("Delete");
        }

        public void run() {
            ITreeSelection structuredSelection;
            Object element;
            if (NMRMeasurementsUI.this.selection != null && (element = (structuredSelection = NMRMeasurementsUI.this.treeViewer.getStructuredSelection()).getFirstElement()) instanceof TreeNode) {
                NMRMeasurementsUI.remove((TreeNode)element, NMRMeasurementsUI.this.selection);
            }
        }
    }
}

