/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.EditorUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanChartUI;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExtendedScanBrowseUI {
    private Composite toolbarInfo;
    private Label labelInfo;
    private ScanChartUI scanChartUI;
    private Button buttonPreviousScan;
    private ComboViewer comboChromatograms;
    private Button buttonNextScan;
    private int masterRetentionTime;
    private final ScanDataSupport scanDataSupport = new ScanDataSupport();
    private EditorUpdateSupport editorUpdateSupport = new EditorUpdateSupport();

    public ExtendedScanBrowseUI(Composite parent) {
        this.initialize(parent);
    }

    public void update(IScan scan) {
        this.setScan(scan);
        this.enableReferenceScanWidgets();
    }

    private void setScan(IScan scan) {
        this.masterRetentionTime = scan != null ? scan.getRetentionTime() : 0;
        this.updateScan(scan);
        this.setComboReferenceItems(scan);
    }

    private void updateScan(IScan scan) {
        this.labelInfo.setText(this.scanDataSupport.getScanLabel(scan));
        this.scanChartUI.setInput(scan);
    }

    private void initialize(Composite parent) {
        Composite container = ControlBuilder.createContainer((Composite)parent);
        this.createToolbarReferences(container);
        this.toolbarInfo = this.createToolbarInfo(container);
        this.createScanChart(container);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        this.setScan(null);
    }

    private Composite createToolbarReferences(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.buttonPreviousScan = this.createPreviousReferenceScanButton(composite);
        this.comboChromatograms = this.createReferenceCombo(composite);
        this.buttonNextScan = this.createNextReferenceScanButton(composite);
        this.createSettingsButton(composite);
        return composite;
    }

    private Button createPreviousReferenceScanButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Get the scan of the previous reference.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/previousYellow.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedScanBrowseUI.this.selectReferenceScan(-1);
            }
        });
        return button;
    }

    private ComboViewer createReferenceCombo(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String label = "";
                if (element instanceof IChromatogramSelection) {
                    IChromatogramSelection chromatogramSelection = (IChromatogramSelection)element;
                    label = chromatogramSelection.getChromatogram().getName();
                }
                return label;
            }
        });
        Combo combo = comboViewer.getCombo();
        combo.setToolTipText("Editor Reference(s) Scan");
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedScanBrowseUI.this.selectReferenceScan(0);
            }
        });
        return comboViewer;
    }

    private Button createNextReferenceScanButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Get the scan of the next reference.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/nextYellow.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedScanBrowseUI.this.selectReferenceScan(1);
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageScans()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    // empty if block
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void createScanChart(Composite parent) {
        this.scanChartUI = new ScanChartUI(parent, 2048);
        this.scanChartUI.setLayoutData(new GridData(1808));
    }

    private void setComboReferenceItems(IScan scan) {
        List<IChromatogramSelection> chromatogramSelections = this.editorUpdateSupport.getChromatogramSelections();
        this.comboChromatograms.setInput(chromatogramSelections);
        if (scan != null) {
            int i = 0;
            while (i < chromatogramSelections.size()) {
                IChromatogramSelection chromatogramSelection = chromatogramSelections.get(i);
                if (chromatogramSelection.getSelectedScan() == scan) {
                    this.comboChromatograms.getCombo().select(i);
                    break;
                }
                ++i;
            }
        }
        this.enableReferenceScanWidgets();
    }

    private void enableReferenceScanWidgets() {
        Combo combo = this.comboChromatograms.getCombo();
        this.buttonPreviousScan.setEnabled(combo.getSelectionIndex() > 0);
        this.buttonNextScan.setEnabled(combo.getSelectionIndex() < combo.getItemCount() - 1);
    }

    private void selectReferenceScan(int moveIndex) {
        Combo combo = this.comboChromatograms.getCombo();
        int index = combo.getSelectionIndex() + moveIndex;
        if (moveIndex < 0) {
            index = index < 0 ? 0 : index;
            combo.select(index);
        } else if (moveIndex > 0) {
            index = index > combo.getItemCount() ? combo.getItemCount() : index;
            combo.select(index);
        }
        IScan referenceScan = null;
        IStructuredSelection structuredSelection = this.comboChromatograms.getStructuredSelection();
        Object object = structuredSelection.getFirstElement();
        if (object instanceof IChromatogramSelection) {
            IChromatogramSelection chromatogramSelection = (IChromatogramSelection)object;
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            int scanNumber = chromatogram.getScanNumber(this.masterRetentionTime);
            referenceScan = chromatogram.getScan(scanNumber);
        }
        this.updateScan(referenceScan);
        this.enableReferenceScanWidgets();
    }
}

