/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.comparator.PeakRetentionTimeComparator;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.ChromatogramSelectionSupport;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;

public class ChromatogramDataSupport {
    private static PeakRetentionTimeComparator peakRetentionTimeComparator = new PeakRetentionTimeComparator(SortOrder.ASC);

    public static String getChromatogramEditorLabel(IChromatogramSelection<?, ?> chromatogramSelection) {
        if (chromatogramSelection != null) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            return String.valueOf(chromatogram.getName()) + " " + ChromatogramDataSupport.getChromatogramType(chromatogramSelection);
        }
        return "";
    }

    public static String getChromatogramType(IChromatogramSelection<?, ?> chromatogramSelection) {
        if (chromatogramSelection != null) {
            return ChromatogramDataSupport.getChromatogramType(chromatogramSelection.getChromatogram());
        }
        return "";
    }

    public static String getChromatogramType(IChromatogram<?> chromatogram) {
        if (chromatogram instanceof IChromatogramMSD) {
            return "[MSD]";
        }
        if (chromatogram instanceof IChromatogramCSD) {
            return "[CSD]";
        }
        if (chromatogram instanceof IChromatogramWSD) {
            return "[WSD]";
        }
        return "";
    }

    public IChromatogramSelection<?, ?> getChromatogramSelection(Object object) {
        if (object instanceof IChromatogramSelection) {
            return (IChromatogramSelection)object;
        }
        if (object instanceof IChromatogramCSD) {
            return new ChromatogramSelectionCSD((IChromatogramCSD)object);
        }
        if (object instanceof IChromatogramMSD) {
            return new ChromatogramSelectionMSD((IChromatogramMSD)object);
        }
        if (object instanceof IChromatogramWSD) {
            return new ChromatogramSelectionWSD((IChromatogramWSD)object);
        }
        return null;
    }

    public static String getChromatogramLabel(IChromatogram<?> chromatogram) {
        return ChromatogramDataSupport.getChromatogramLabel(chromatogram);
    }

    public static String getChromatogramLabel(IChromatogramOverview chromatogramOverview) {
        StringBuilder builder = new StringBuilder();
        if (chromatogramOverview != null) {
            builder.append("Chromatogram: ");
            builder.append(chromatogramOverview.getName());
        } else {
            builder.append("No chromatogram has been selected yet.");
        }
        return builder.toString();
    }

    public static String getChromatogramLabelExtended(IChromatogram<?> chromatogram) {
        StringBuilder builder = new StringBuilder();
        if (chromatogram != null) {
            builder.append("Chromatogram: ");
            builder.append(chromatogram.getName());
            builder.append(" ");
            if (chromatogram instanceof IChromatogramMSD) {
                builder.append("(MSD)");
            } else if (chromatogram instanceof IChromatogramCSD) {
                builder.append("(CSD)");
            } else if (chromatogram instanceof IChromatogramWSD) {
                builder.append("(WSD)");
            }
            String miscInfoSeparated = chromatogram.getMiscInfoSeparated();
            if ("".equals(miscInfoSeparated)) {
                String miscInfo = chromatogram.getMiscInfo();
                if (!"".equals(miscInfo)) {
                    builder.append(" | ");
                    builder.append(miscInfo);
                }
            } else {
                builder.append(" | ");
                builder.append(miscInfoSeparated);
            }
        } else {
            builder.append("No chromatogram has been selected yet.");
        }
        return builder.toString();
    }

    public static String getChromatogramSelectionLabel(IChromatogramSelection<?, ?> chromatogramSelection) {
        StringBuilder builder = new StringBuilder();
        if (chromatogramSelection != null) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            if (chromatogram != null) {
                DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");
                builder.append("Chromatogram: ");
                builder.append(chromatogram.getName());
                builder.append(" | ");
                builder.append("RT: ");
                builder.append(decimalFormat.format((double)chromatogramSelection.getStartRetentionTime() / 60000.0));
                builder.append(" - ");
                builder.append(decimalFormat.format((double)chromatogramSelection.getStopRetentionTime() / 60000.0));
            }
        } else {
            builder.append("No chromatogram has been selected yet.");
        }
        return builder.toString();
    }

    public static <T extends IPeak> List<T> getPeaks(IChromatogram<T> chromatogram) {
        return ChromatogramDataSupport.getPeaks(chromatogram, null);
    }

    public static <T extends IPeak> List<T> getPeaks(IChromatogram<T> chromatogram, IChromatogramSelection<T, ?> selectedRange) {
        if (selectedRange != null) {
            return chromatogram.getPeaks(selectedRange);
        }
        return chromatogram.getPeaks();
    }

    public static List<IScan> getIdentifiedScans(IChromatogram<?> chromatogram) {
        return ChromatogramDataSupport.getIdentifiedScans(chromatogram, null);
    }

    public static List<IScan> getIdentifiedScans(IChromatogram<? extends IPeak> chromatogram, IChromatogramSelection<?, ?> selectedRange) {
        int startRetentionTime = 0;
        int stopRetentionTime = 0;
        boolean useSelectedRange = false;
        if (selectedRange != null) {
            useSelectedRange = true;
            startRetentionTime = selectedRange.getStartRetentionTime();
            stopRetentionTime = selectedRange.getStopRetentionTime();
        }
        ArrayList<IScan> scans = new ArrayList<IScan>();
        if (chromatogram != null) {
            for (IScan scan : chromatogram.getScans()) {
                if (useSelectedRange) {
                    if (!ChromatogramDataSupport.scanIsInSelectedRange(scan, startRetentionTime, stopRetentionTime) || !ChromatogramDataSupport.scanContainsTargets(scan)) continue;
                    scans.add(scan);
                    continue;
                }
                if (!ChromatogramDataSupport.scanContainsTargets(scan)) continue;
                scans.add(scan);
            }
        }
        return scans;
    }

    public static <T extends IPeak> List<T> getPeaks(IChromatogramSelection<T, ?> chromatogramSelection, boolean extractPeaksInSelectedRange) {
        IChromatogram chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogram()) != null) {
            if (extractPeaksInSelectedRange) {
                return chromatogram.getPeaks(chromatogramSelection);
            }
            return chromatogram.getPeaks();
        }
        return Collections.emptyList();
    }

    public static List<? extends IScan> getIdentifiedScans(IChromatogramSelection<?, ?> chromatogramSelection, boolean showScansInSelectedRange) {
        List<Object> scans = new ArrayList();
        if (chromatogramSelection != null) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            scans = showScansInSelectedRange ? ChromatogramDataSupport.getIdentifiedScans((IChromatogram<? extends IPeak>)chromatogram, chromatogramSelection) : ChromatogramDataSupport.getIdentifiedScans(chromatogram);
        }
        return scans;
    }

    public static void adjustChromatogramSelection(IPeak peak, IChromatogramSelection<?, ?> chromatogramSelection) {
        if (chromatogramSelection != null) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            List peaks = ChromatogramDataSupport.getPeaks(chromatogram);
            ArrayList peaksSelection = new ArrayList(chromatogram.getPeaks(chromatogramSelection));
            Collections.sort(peaks, peakRetentionTimeComparator);
            Collections.sort(peaksSelection, peakRetentionTimeComparator);
            if (!((IPeak)peaks.get(0)).equals(peak) && !((IPeak)peaks.get(peaks.size() - 1)).equals(peak)) {
                if (((IPeak)peaksSelection.get(0)).equals(peak)) {
                    ChromatogramSelectionSupport.moveRetentionTimeWindow(chromatogramSelection, (MoveDirection)MoveDirection.LEFT, (int)5);
                } else if (((IPeak)peaksSelection.get(peaksSelection.size() - 1)).equals(peak)) {
                    ChromatogramSelectionSupport.moveRetentionTimeWindow(chromatogramSelection, (MoveDirection)MoveDirection.RIGHT, (int)5);
                }
            }
        }
    }

    private static boolean scanIsInSelectedRange(IScan scan, int startRetentionTime, int stopRetentionTime) {
        int retentionTime = scan.getRetentionTime();
        return retentionTime >= startRetentionTime && retentionTime <= stopRetentionTime;
    }

    private static boolean scanContainsTargets(IScan scan) {
        if (scan != null) {
            return !scan.getTargets().isEmpty();
        }
        return false;
    }
}

