/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support;

import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceStoreTargetDisplaySettings
implements TargetDisplaySettings {
    private final IPreferenceStore preferenceStore;

    private PreferenceStoreTargetDisplaySettings(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        preferenceStore.setDefault("chromatogramPeakLabelsRotation", 90);
        preferenceStore.setDefault("chromatogramPeakLabelsCollisionDetectionDepth", 0);
    }

    @Override
    public boolean isShowPeakLabels() {
        return this.preferenceStore.getBoolean("showChromatogramPeakLabels");
    }

    @Override
    public boolean isShowScanLables() {
        return this.preferenceStore.getBoolean("showChromatogramScanLabels");
    }

    @Override
    public TargetDisplaySettings.LibraryField getField() {
        String string = this.preferenceStore.getString("targetLabelField");
        if (string != null) {
            try {
                return TargetDisplaySettings.LibraryField.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return TargetDisplaySettings.LibraryField.NAME;
    }

    @Override
    public void setField(TargetDisplaySettings.LibraryField libraryField) {
        this.preferenceStore.setValue("targetLabelField", libraryField.name());
    }

    @Override
    public void setShowPeakLabels(boolean showPeakLabels) {
        this.preferenceStore.setValue("showChromatogramPeakLabels", showPeakLabels);
    }

    @Override
    public void setShowScanLables(boolean showScanLables) {
        this.preferenceStore.setValue("showChromatogramScanLabels", showScanLables);
    }

    public static TargetDisplaySettings getSettings(IPreferenceStore preferenceStore) {
        return new PreferenceStoreTargetDisplaySettings(preferenceStore);
    }

    @Override
    public int getRotation() {
        return this.preferenceStore.getInt("chromatogramPeakLabelsRotation");
    }

    @Override
    public void setRotation(int degree) {
        this.preferenceStore.setValue("chromatogramPeakLabelsRotation", degree);
    }

    @Override
    public int getCollisionDetectionDepth() {
        return this.preferenceStore.getInt("chromatogramPeakLabelsCollisionDetectionDepth");
    }

    @Override
    public void setCollisionDetectionDepth(int depth) {
        this.preferenceStore.setValue("chromatogramPeakLabelsCollisionDetectionDepth", depth);
    }
}

