/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.segments;

import java.util.function.Consumer;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeNode;

public class AnalysisSegmentSelectionChangedListener<X>
implements ISelectionChangedListener {
    private final Consumer<X> selectionConsumer;
    private final Class<X> type;

    public AnalysisSegmentSelectionChangedListener(Class<X> type, Consumer<X> selectionConsumer) {
        this.type = type;
        this.selectionConsumer = selectionConsumer;
        selectionConsumer.accept(null);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IScan scan;
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof TreeNode) {
                element = ((TreeNode)element).getValue();
            }
            if ((scan = (IScan)Adapters.adapt((Object)element, IScan.class)) != null) {
                Activator.getDefault().getEventBroker().send("scan/xxd/update/selection", (Object)scan);
            }
            if (this.type.isInstance(element)) {
                this.selectionConsumer.accept(this.type.cast(element));
                return;
            }
        }
        this.selectionConsumer.accept(null);
    }
}

