/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.segments;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.ux.extension.xxd.ui.segments.AnalysisSegmentColorScheme;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;

public class AnalysisSegmentPaintListener<X extends IAnalysisSegment>
implements ICustomPaintListener {
    private static final int ALPHA = 100;
    private final AnalysisSegmentColorScheme colorScheme;
    private final Supplier<Collection<X>> segmentSupplier;
    private final Predicate<X> selectionCheck;
    private boolean paintArea = true;
    private boolean paintLines = false;
    private int alpha = 100;

    public AnalysisSegmentPaintListener(AnalysisSegmentColorScheme colorScheme, Supplier<Collection<X>> segmentSupplier, Predicate<X> selectionCheck) {
        this.colorScheme = colorScheme;
        this.segmentSupplier = segmentSupplier;
        this.selectionCheck = selectionCheck;
    }

    public void paintControl(PaintEvent evt) {
        IPlotArea plotArea;
        Chart chart;
        ISeries series;
        Widget widget = evt.widget;
        if (widget instanceof IPlotArea && (series = (chart = (plotArea = (IPlotArea)widget).getChart()).getSeriesSet().getSeries("Chromatogram")) != null) {
            GC gc = evt.gc;
            AnalysisSegmentColorScheme.AnalysisSegmentColors colors = this.colorScheme.create(gc);
            IAxis xAxis = chart.getAxisSet().getXAxis(series.getXAxisId());
            Rectangle clientArea = chart.getClientArea();
            int y = clientArea.y;
            int height = clientArea.height;
            gc.setLineStyle(1);
            boolean alternate = false;
            gc.setForeground(colors.get(AnalysisSegmentColorScheme.Type.LINE));
            for (IAnalysisSegment segment : this.segmentSupplier.get()) {
                int x1 = xAxis.getPixelCoordinate((double)segment.getStartRetentionTime());
                int x2 = xAxis.getPixelCoordinate((double)segment.getStopRetentionTime());
                boolean isSelected = this.selectionCheck.test(segment);
                if (isSelected) {
                    gc.setBackground(colors.get(AnalysisSegmentColorScheme.Type.SELECTION));
                    gc.setAlpha(this.alpha + 50);
                } else if (alternate) {
                    gc.setBackground(colors.get(AnalysisSegmentColorScheme.Type.SEGMENT_ODD));
                    gc.setAlpha(this.alpha);
                } else {
                    gc.setBackground(colors.get(AnalysisSegmentColorScheme.Type.SEGMENT_EVEN));
                    gc.setAlpha(this.alpha);
                }
                if (this.paintArea || isSelected) {
                    gc.fillRectangle(x1, y, x2 - x1, height);
                }
                if (isSelected) {
                    gc.setAlpha(255);
                } else {
                    gc.setAlpha(this.alpha + 50);
                }
                if (this.paintLines || isSelected) {
                    if (isSelected && this.paintArea) {
                        gc.drawLine(x1, 0, x1, height);
                    }
                    gc.drawLine(x2, 0, x2, height);
                }
                boolean bl = alternate = !alternate;
            }
            colors.dispose();
        }
    }

    public boolean drawBehindSeries() {
        return true;
    }

    public void setPaintArea(boolean paintArea) {
        this.paintArea = paintArea;
    }

    public void setPaintLines(boolean paintLines) {
        this.paintLines = paintLines;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }
}

