/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.EnhancedUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedTargetsUI;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;

public class TargetsPart
extends EnhancedUpdateSupport
implements IUpdateSupport {
    private ExtendedTargetsUI extendedTargetsUI;

    @Inject
    public TargetsPart(Composite parent, MPart part) {
        super(parent, Activator.getDefault().getDataUpdateSupport(), "peak/xxd/update/selection", part);
    }

    @Override
    public void createControl(Composite parent) {
        this.extendedTargetsUI = new ExtendedTargetsUI(parent);
    }

    @Override
    public void updateSelection(List<Object> objects, String topic) {
        if (objects.size() == 1) {
            if (this.isChromatogramUnloadEvent(topic) || this.isOtherUnloadEvent(topic)) {
                this.extendedTargetsUI.update(null);
            } else {
                Object object = objects.get(0);
                if (this.isChromatogramTopic(topic)) {
                    if (object instanceof IChromatogramSelection) {
                        IChromatogramSelection chromatogramSelection = (IChromatogramSelection)object;
                        object = chromatogramSelection.getChromatogram();
                        this.extendedTargetsUI.update(object);
                    }
                } else if (this.isScanOrPeakTopic(topic) || this.isIdentificationTopic(topic)) {
                    this.extendedTargetsUI.update(object);
                }
            }
        }
    }

    private boolean isChromatogramUnloadEvent(String topic) {
        return topic.equals("chromatogram/xxd/unload/chromatogramselection");
    }

    private boolean isChromatogramTopic(String topic) {
        if (topic.equals("chromatogram/msd/update/chromatogramselection")) {
            return true;
        }
        if (topic.equals("chromatogram/csd/update/chromatogramselection")) {
            return true;
        }
        return topic.equals("chromatogram/wsd/update/chromatogramselection");
    }

    private boolean isOtherUnloadEvent(String topic) {
        if (topic.equals("scan/xxd/unload/selection")) {
            return true;
        }
        if (topic.equals("peak/xxd/unload/selection")) {
            return true;
        }
        return topic.equals("identification/targets/unload/selection");
    }

    private boolean isScanOrPeakTopic(String topic) {
        if (topic.equals("scan/xxd/update/selection")) {
            return true;
        }
        return topic.equals("peak/xxd/update/selection");
    }

    private boolean isIdentificationTopic(String topic) {
        return topic.equals("identification/targets/update/selection");
    }
}

