/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.EnhancedUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedPeakScanListUI;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.swt.widgets.Composite;

public class PeakScanListPart
extends EnhancedUpdateSupport
implements IUpdateSupport {
    private ExtendedPeakScanListUI extendedPeakScanListUI;
    private boolean linkWithEditor = true;

    @Inject
    public PeakScanListPart(Composite parent, MPart part) {
        super(parent, Activator.getDefault().getDataUpdateSupport(), "chromatogram/xxd/load/chromatogramselection", part);
    }

    @Inject
    @Optional
    public void updatePeakSelection(@UIEventTopic(value="peak/xxd/update/selection") IPeak peak) {
        if (this.linkWithEditor) {
            this.extendedPeakScanListUI.updateSelection();
        }
    }

    @Override
    public void createControl(Composite parent) {
        this.extendedPeakScanListUI = new ExtendedPeakScanListUI(parent, Activator.getDefault().getEventBroker(), Activator.getDefault().getPreferenceStore());
    }

    @Override
    public void updateSelection(List<Object> objects, String topic) {
        if (objects.size() == 1) {
            Object object;
            if (this.isChromatogramUnloadEvent(topic)) {
                this.extendedPeakScanListUI.updateChromatogramSelection(null);
            } else if (this.isChromatogramTopic(topic) && (object = objects.get(0)) instanceof IChromatogramSelection) {
                IChromatogramSelection chromatogramSelection = (IChromatogramSelection)object;
                this.extendedPeakScanListUI.updateChromatogramSelection(chromatogramSelection);
            }
        }
    }

    private boolean isChromatogramUnloadEvent(String topic) {
        return topic.equals("chromatogram/xxd/unload/chromatogramselection");
    }

    private boolean isChromatogramTopic(String topic) {
        if (topic.equals("chromatogram/msd/update/chromatogramselection")) {
            return true;
        }
        if (topic.equals("chromatogram/csd/update/chromatogramselection")) {
            return true;
        }
        if (topic.equals("chromatogram/wsd/update/chromatogramselection")) {
            return true;
        }
        return topic.equals("chromatogram/xxd/load/chromatogramselection");
    }

    public static final class LinkWithEditorHandler {
        @Execute
        void execute(MPart part, MDirectToolItem toolItem) {
            Object object = part.getObject();
            if (object instanceof PeakScanListPart) {
                PeakScanListPart listPart = (PeakScanListPart)object;
                listPart.linkWithEditor = toolItem.isSelected();
                listPart.updatePeakSelection(null);
            }
        }
    }
}

