/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.model.support.PeakQuantitationsExtractor;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.swt.ui.components.peaks.PeakQuantitationListUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PeakQuantitationListPart
extends AbstractDataUpdateSupport
implements IDataUpdateSupport {
    private PeakQuantitationListUI peakQuantitationListUI;
    private PeakQuantitationsExtractor peakQuantitationsExtractor = new PeakQuantitationsExtractor();

    @Inject
    public PeakQuantitationListPart(Composite parent, MPart part) {
        super(part);
        parent.setLayout((Layout)new FillLayout());
        this.peakQuantitationListUI = new PeakQuantitationListUI(parent, 66306);
    }

    @Focus
    public void setFocus() {
        this.updateObjects(this.getObjects(), this.getTopic());
        this.peakQuantitationListUI.getTable().setFocus();
    }

    @Override
    public void registerEvents() {
        this.registerEvent("chromatogram/csd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/msd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/wsd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/xxd/load/chromatogramselection", "org.eclipse.e4.data");
        this.registerEvent("chromatogram/xxd/unload/chromatogramselection", "org.eclipse.e4.data");
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        if (objects.size() == 1) {
            Object object = null;
            if (!this.isUnloadEvent(topic)) {
                object = objects.get(0);
                if (object instanceof IChromatogramSelection) {
                    IChromatogramSelection chromatogramSelection = (IChromatogramSelection)object;
                    IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                    List peaks = null;
                    if (chromatogram instanceof IChromatogramMSD) {
                        IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                        peaks = chromatogramMSD.getPeaks((IRetentionTimeRange)((IChromatogramSelectionMSD)chromatogramSelection));
                    } else if (chromatogram instanceof IChromatogramCSD) {
                        IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
                        peaks = chromatogramCSD.getPeaks((IRetentionTimeRange)((IChromatogramSelectionCSD)chromatogramSelection));
                    } else if (chromatogram instanceof IChromatogramWSD) {
                        IChromatogramWSD chromatogramWSD = (IChromatogramWSD)chromatogram;
                        peaks = chromatogramWSD.getPeaks((IRetentionTimeRange)((IChromatogramSelectionWSD)chromatogramSelection));
                    }
                    this.peakQuantitationListUI.update(this.peakQuantitationsExtractor.extract(peaks));
                } else {
                    this.peakQuantitationListUI.update(null);
                }
            } else {
                this.peakQuantitationListUI.update(null);
            }
        }
    }

    private boolean isUnloadEvent(String topic) {
        return topic.equals("chromatogram/xxd/unload/chromatogramselection");
    }
}

