/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.ux.extension.msd.ui.support.DatabaseSupport;
import org.eclipse.chemclipse.ux.extension.msd.ui.support.MassSpectrumSupport;
import org.eclipse.chemclipse.ux.extension.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.ux.extension.ui.swt.DataExplorerUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.editors.ProjectExplorerSupportFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.GenericSupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.SupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageFileExplorer;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DataExplorerPart {
    public static final String TAG_MSD_DATA = "DataType.MSD";
    private DataExplorerUI dataExplorerUI;
    @Inject
    private IEventBroker broker;
    @Inject
    private IEclipseContext context;
    @Inject
    ISupplierFileIdentifier gloabalIdentifier;
    private List<String> tags;

    @PostConstruct
    public void init(Composite parent, MPart part) {
        this.dataExplorerUI = new DataExplorerUI(parent, this.broker, DataExplorerPart.getPreferenceStore());
        this.tags = part.getTags();
        this.setSupplierFileEditorSupport();
    }

    public void setSupplierFileEditorSupport() {
        ArrayList<Object> editorSupportList = new ArrayList<Object>();
        if (this.tags.isEmpty()) {
            IPreferenceStore preferenceStore = DataExplorerPart.getPreferenceStore();
            if (preferenceStore.getBoolean("showDataMSD")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.MSD, () -> this.context));
            }
            if (preferenceStore.getBoolean("showLibraryMSD")) {
                editorSupportList.add(DatabaseSupport.getInstanceEditorSupport());
            }
            if (preferenceStore.getBoolean("showScansMSD")) {
                editorSupportList.add(MassSpectrumSupport.getInstanceEditorSupport());
            }
            if (preferenceStore.getBoolean("showDataCSD")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.CSD, () -> this.context));
            }
            if (preferenceStore.getBoolean("showDataWSD")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.WSD, () -> this.context));
            }
            if (preferenceStore.getBoolean("showDataXIR")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.XIR, () -> this.context));
            }
            if (preferenceStore.getBoolean("showDataNMR")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.NMR, () -> this.context));
            }
            if (preferenceStore.getBoolean("showDataCAL")) {
                editorSupportList.add(new ProjectExplorerSupportFactory(DataType.CAL).getInstanceEditorSupport());
            }
            if (preferenceStore.getBoolean("showDataPCR")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.PCR, () -> this.context));
            }
            if (preferenceStore.getBoolean("showDataSequence")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.SEQ, () -> this.context));
            }
            if (preferenceStore.getBoolean("showDataMethod")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.MTH, () -> this.context));
            }
            if (preferenceStore.getBoolean("showDataQuantDB")) {
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.QDB, () -> this.context));
            }
        } else {
            for (String tag : this.tags) {
                if (!TAG_MSD_DATA.equals(tag)) continue;
                editorSupportList.add((Object)new SupplierEditorSupport(DataType.MSD, () -> this.context));
            }
        }
        editorSupportList.add(new GenericSupplierEditorSupport(this.gloabalIdentifier, () -> this.context));
        this.dataExplorerUI.setSupplierFileIdentifier(editorSupportList);
        this.dataExplorerUI.expandLastDirectoryPath();
    }

    public static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static File getUserLocation() {
        return new File(DataExplorerPart.getPreferenceStore().getString("userLocation"));
    }

    public static final class DataExplorerSettingsHandler {
        @Execute
        public void execute(MPart part, @Named(value="activeShell") Shell shell) {
            DataExplorerPart explorer = (DataExplorerPart)part.getObject();
            PreferenceManager preferenceManager = new PreferenceManager();
            preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageFileExplorer()));
            preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePage()));
            PreferenceDialog preferenceDialog = new PreferenceDialog(shell, preferenceManager);
            preferenceDialog.create();
            preferenceDialog.setMessage("Settings");
            if (preferenceDialog.open() == 0) {
                try {
                    explorer.setSupplierFileEditorSupport();
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)shell, (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                }
            }
        }
    }

    public static final class ResetDataExplorerHandler {
        @Execute
        public void execute(MPart part) {
            DataExplorerPart explorer = (DataExplorerPart)part.getObject();
            explorer.dataExplorerUI.expandLastDirectoryPath();
        }
    }
}

