/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.part.support;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Table;

public class ListSupport {
    private static final Logger logger = Logger.getLogger(ListSupport.class);
    private static final String COLUMN_DELIMITER = " ";

    public void setColumnOrder(Table table, String columnOrder) {
        try {
            int[] columns = this.convertColumnOrder(columnOrder);
            table.setColumnOrder(columns);
        }
        catch (IllegalArgumentException | SWTException throwable) {
            // empty catch block
        }
    }

    public String getColumnOrder(Table table) {
        return this.convertColumnOrder(table.getColumnOrder());
    }

    private String convertColumnOrder(int[] columnOrder) {
        StringBuilder builder = new StringBuilder();
        int[] nArray = columnOrder;
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            builder.append(i);
            builder.append(COLUMN_DELIMITER);
            ++n2;
        }
        return builder.toString().trim();
    }

    private int[] convertColumnOrder(String columnOrder) {
        String[] values = columnOrder.split(COLUMN_DELIMITER);
        int size = values.length;
        int[] columns = new int[size];
        int i = 0;
        while (i < size) {
            try {
                columns[i] = Integer.parseInt(values[i]);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        return columns;
    }
}

