/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.methods;

import java.io.IOException;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsUI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SettingsPreferencesPage<T>
extends WizardPage {
    private boolean isDontAskAgain;
    private boolean isUseSystemDefaults;
    private String jsonSettings;
    private final ProcessorPreferences<T> preferences;

    public SettingsPreferencesPage(ProcessorPreferences<T> preferences) {
        super(SettingsPreferencesPage.class.getName());
        this.preferences = preferences;
    }

    public void createControl(Composite parent) {
        SettingsUI<T> settingsUI;
        boolean requiresUserSettings = this.preferences.requiresUserSettings();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        final Button buttonDefault = new Button(composite, 16);
        buttonDefault.setText("Use System Options");
        if (requiresUserSettings) {
            buttonDefault.setEnabled(false);
            buttonDefault.setToolTipText("This processor does not offer System options or they are not applicable at the moment");
        }
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        final Button buttonUser = new Button(composite, 16);
        buttonUser.setText("Use Specific Options");
        try {
            settingsUI = new SettingsUI<T>(composite, this.preferences);
        }
        catch (IOException e1) {
            throw new RuntimeException("reading settings failed", e1);
        }
        settingsUI.setLayoutData(new GridData(4, 4, true, true));
        final Listener validationListener = new Listener(){

            public void handleEvent(Event event) {
                SettingsPreferencesPage.this.jsonSettings = null;
                if (buttonUser.getSelection()) {
                    IStatus validate = settingsUI.getControl().validate();
                    if (validate.isOK()) {
                        SettingsPreferencesPage.this.setErrorMessage(null);
                        SettingsPreferencesPage.this.setPageComplete(true);
                    } else {
                        SettingsPreferencesPage.this.setErrorMessage(validate.getMessage());
                        SettingsPreferencesPage.this.setPageComplete(false);
                    }
                } else {
                    SettingsPreferencesPage.this.setErrorMessage(null);
                    SettingsPreferencesPage.this.setPageComplete(true);
                }
                try {
                    SettingsPreferencesPage.this.jsonSettings = settingsUI.getControl().getSettings();
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "Error while fetching settings", (Throwable)e));
                    SettingsPreferencesPage.this.setErrorMessage(e.toString());
                    SettingsPreferencesPage.this.setPageComplete(false);
                }
            }
        };
        SelectionListener radioButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                settingsUI.setEnabled(buttonUser.getSelection());
                validationListener.handleEvent(null);
                SettingsPreferencesPage.this.isUseSystemDefaults = buttonDefault.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        buttonDefault.addSelectionListener(radioButtonListener);
        buttonUser.addSelectionListener(radioButtonListener);
        if (this.preferences.getDialogBehaviour() == ProcessorPreferences.DialogBehavior.NONE) {
            this.isDontAskAgain = false;
        } else {
            final Button buttonDontAskAgain = new Button(composite, 32);
            buttonDontAskAgain.setLayoutData((Object)new GridData(131072, 1024, true, false));
            buttonDontAskAgain.setText("Remember my decision and don't ask again");
            buttonDontAskAgain.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SettingsPreferencesPage.this.isDontAskAgain = buttonDontAskAgain.getSelection();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.isDontAskAgain = this.preferences.getDialogBehaviour() != ProcessorPreferences.DialogBehavior.SHOW;
            buttonDontAskAgain.setSelection(this.isDontAskAgain);
        }
        if (this.preferences.isUseSystemDefaults() && !requiresUserSettings) {
            buttonDefault.setSelection(true);
        } else {
            buttonUser.setSelection(true);
        }
        radioButtonListener.widgetSelected(null);
        settingsUI.getControl().addChangeListener(validationListener);
        this.setControl((Control)composite);
    }

    public boolean getIsDontAskAgainEdited() {
        return this.isDontAskAgain;
    }

    public String getSettingsEdited() throws IOException {
        return this.jsonSettings;
    }

    public boolean getIsUseSystemDefaultsEdited() {
        return this.isUseSystemDefaults;
    }
}

