/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class ResponseFactorValidator
implements IValidator {
    private static final String ERROR = "Please enter a correct response factor.";
    private static final String ERROR_VALUE_RANGE = "The response factor must be not <= 0.";
    private double responseFactor = 0.0;

    public IStatus validate(Object value) {
        String message;
        block8: {
            message = null;
            this.responseFactor = 0.0;
            if (value == null) {
                message = ERROR;
            } else if (value instanceof String) {
                String text = ((String)value).trim();
                try {
                    double responseFactor = Double.parseDouble(text);
                    if (responseFactor <= 0.0) {
                        message = ERROR_VALUE_RANGE;
                        break block8;
                    }
                    this.responseFactor = responseFactor;
                }
                catch (NumberFormatException e) {
                    message = ERROR;
                }
            } else {
                message = ERROR;
            }
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public double getResponseFactor() {
        return this.responseFactor;
    }
}

