/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation;

import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.support.util.ValueParserSupport;
import org.eclipse.chemclipse.xxd.model.quantitation.QuantitationCompound;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class QuantitationCompoundValidator
extends ValueParserSupport
implements IValidator {
    public static final String DEMO = "Styrene | mg/kg | 5.68";
    private static final String DELIMITER = "|";
    private static final String ERROR_TARGET = "Please enter a compound, e.g.: Styrene | mg/kg | 5.68";
    private String name;
    private String concentrationUnit;
    private int retentionTime;

    public IStatus validate(Object value) {
        String message = null;
        if (value == null) {
            message = ERROR_TARGET;
        } else if (value instanceof String) {
            String text = ((String)value).trim();
            if ("".equals(text.trim())) {
                message = ERROR_TARGET;
            } else {
                String[] values = text.trim().split("\\|");
                this.name = this.parseString(values, 0);
                this.concentrationUnit = this.parseString(values, 1);
                this.retentionTime = (int)(this.parseDouble(values, 2, 0.0) * 60000.0);
            }
        } else {
            message = ERROR_TARGET;
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public IQuantitationCompound getQuantitationCompound(boolean createDefaultSignal) {
        QuantitationCompound quantitationCompound = new QuantitationCompound(this.name, this.concentrationUnit, this.retentionTime);
        if (createDefaultSignal) {
            quantitationCompound.setQuantitationSignalTIC();
        }
        return quantitationCompound;
    }
}

