/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.TableConfig;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;

public class TableConfigSupport
implements TableConfig {
    private Supplier<Collection<? extends ViewerColumn>> columns;

    public TableConfigSupport(Collection<? extends ViewerColumn> columns) {
        this(() -> columns);
    }

    public TableConfigSupport(Supplier<Collection<? extends ViewerColumn>> columns) {
        this.columns = columns;
    }

    @Override
    public void setVisibleColumns(Set<String> visibleColumns) {
        for (ViewerColumn viewerColumn : this.columns.get()) {
            Item item = this.getItem(viewerColumn);
            if (visibleColumns.contains(item.getText())) {
                this.restoreItem(item);
                continue;
            }
            this.hideItem(item);
        }
    }

    private void restoreItem(Item item) {
        Object oldWidth = item.getData("OLD_WIDTH");
        Object oldResizable = item.getData("OLD_RESIZABLE");
        if (item instanceof TreeColumn) {
            TreeColumn column = (TreeColumn)item;
            if (oldWidth instanceof Number) {
                column.setWidth(((Number)oldWidth).intValue());
            }
            if (oldResizable instanceof Boolean) {
                column.setResizable(((Boolean)oldResizable).booleanValue());
            }
        } else if (item instanceof TableColumn) {
            TableColumn column = (TableColumn)item;
            if (oldWidth instanceof Number) {
                column.setWidth(((Number)oldWidth).intValue());
            }
            if (oldResizable instanceof Boolean) {
                column.setResizable(((Boolean)oldResizable).booleanValue());
            }
        }
    }

    @Override
    public Set<String> getColumns() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (ViewerColumn viewerColumn : this.columns.get()) {
            Item item = this.getItem(viewerColumn);
            if (item == null) continue;
            set.add(item.getText());
        }
        return set;
    }

    private void hideItem(Item item) {
        if (item instanceof TreeColumn) {
            TreeColumn column = (TreeColumn)item;
            item.setData("OLD_WIDTH", (Object)column.getWidth());
            item.setData("OLD_RESIZABLE", (Object)column.getResizable());
            column.setWidth(0);
            column.setResizable(false);
        } else if (item instanceof TableColumn) {
            TableColumn column = (TableColumn)item;
            item.setData("OLD_WIDTH", (Object)column.getWidth());
            item.setData("OLD_RESIZABLE", (Object)column.getResizable());
            column.setWidth(0);
            column.setResizable(false);
        }
    }

    private Item getItem(ViewerColumn column) {
        if (column instanceof TreeViewerColumn) {
            return ((TreeViewerColumn)column).getColumn();
        }
        if (column instanceof TableViewerColumn) {
            return ((TableViewerColumn)column).getColumn();
        }
        return null;
    }

    @Override
    public int getColumWidth(String columnName) {
        for (ViewerColumn viewerColumn : this.columns.get()) {
            Item item = this.getItem(viewerColumn);
            if (item == null || !item.getText().equals(columnName)) continue;
            if (item instanceof TreeColumn) {
                return ((TreeColumn)item).getWidth();
            }
            if (!(item instanceof TableColumn)) continue;
            return ((TableColumn)item).getWidth();
        }
        return -1;
    }

    @Override
    public void setColumWidth(String columnName, int width) {
        for (ViewerColumn viewerColumn : this.columns.get()) {
            Item item = this.getItem(viewerColumn);
            if (item == null || !item.getText().equals(columnName)) continue;
            if (item instanceof TreeColumn) {
                ((TreeColumn)item).setWidth(width);
                return;
            }
            if (!(item instanceof TableColumn)) continue;
            ((TableColumn)item).setWidth(width);
            return;
        }
    }
}

