/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramExportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramExportRunnable.class);
    private File data;
    private File file;
    private IChromatogram chromatogram;
    private ISupplier supplier;
    private DataType dataType;

    public ChromatogramExportRunnable(File file, IChromatogram chromatogram, ISupplier supplier, DataType dataType) {
        this.file = file;
        this.chromatogram = chromatogram;
        this.supplier = supplier;
        this.dataType = dataType;
    }

    public File getData() {
        return this.data;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Export Chromatogram", -1);
            IProcessingInfo processingInfo = null;
            switch (this.dataType) {
                case MSD_NOMINAL: 
                case MSD_TANDEM: 
                case MSD_HIGHRES: 
                case MSD: {
                    if (!(this.chromatogram instanceof IChromatogramMSD)) break;
                    IChromatogramMSD chromatogramMSD = (IChromatogramMSD)this.chromatogram;
                    processingInfo = ChromatogramConverterMSD.getInstance().convert(this.file, (IChromatogram)chromatogramMSD, this.supplier.getId(), monitor);
                    break;
                }
                case CSD: {
                    if (!(this.chromatogram instanceof IChromatogramCSD)) break;
                    IChromatogramCSD chromatogramCSD = (IChromatogramCSD)this.chromatogram;
                    processingInfo = ChromatogramConverterCSD.getInstance().convert(this.file, (IChromatogram)chromatogramCSD, this.supplier.getId(), monitor);
                    break;
                }
                case WSD: {
                    if (!(this.chromatogram instanceof IChromatogramWSD)) break;
                    IChromatogramWSD chromatogramWSD = (IChromatogramWSD)this.chromatogram;
                    processingInfo = ChromatogramConverterWSD.getInstance().convert(this.file, (IChromatogram)chromatogramWSD, this.supplier.getId(), monitor);
                }
            }
            if (processingInfo != null) {
                this.data = (File)processingInfo.getProcessingResult();
            }
        }
        finally {
            monitor.done();
        }
    }
}

