/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RetentionIndexLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IRetentionIndexEntry) {
            IRetentionIndexEntry retentionIndexEntry = (IRetentionIndexEntry)element;
            switch (columnIndex) {
                case 0: {
                    text = this.decimalFormat.format((double)retentionIndexEntry.getRetentionTime() / 60000.0);
                    break;
                }
                case 1: {
                    if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                        text = Integer.toString((int)retentionIndexEntry.getRetentionIndex());
                        break;
                    }
                    text = this.decimalFormat.format(retentionIndexEntry.getRetentionIndex());
                    break;
                }
                case 2: {
                    text = retentionIndexEntry.getName();
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/peak.gif", "16x16");
        return image;
    }
}

