/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class QuantPeaksEditingSupport
extends EditingSupport {
    private static final Logger logger = Logger.getLogger(QuantPeaksEditingSupport.class);
    private CellEditor cellEditor;
    private ExtendedTableViewer tableViewer;
    private String column;

    public QuantPeaksEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        block10: {
            if (!(element instanceof IQuantitationPeak)) break block10;
            IQuantitationPeak peak = (IQuantitationPeak)element;
            switch (this.column) {
                case "Concentration": {
                    return Double.toString(peak.getConcentration());
                }
                case "Unit": {
                    return peak.getConcentrationUnit();
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block10: {
            if (!(element instanceof IQuantitationPeak)) break block10;
            IQuantitationPeak peak = (IQuantitationPeak)element;
            switch (this.column) {
                case "Concentration": {
                    double concentration = this.parseConcentration((String)value);
                    if (Double.isNaN(concentration)) break;
                    peak.setConcentration(concentration);
                    break;
                }
                case "Unit": {
                    peak.setConcentrationUnit((String)value);
                }
            }
            this.tableViewer.refresh();
        }
    }

    private double parseConcentration(String value) {
        double concentration = Double.NaN;
        try {
            double val = Double.parseDouble(value);
            if (val >= 0.0) {
                concentration = val;
            }
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return concentration;
    }
}

