/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.handlers;

import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractIdentificationsHandler {
    private static IChromatogramSelection chromatogramSelection;
    private ChromatogramDataSupport chromatogramDataSupport = new ChromatogramDataSupport();

    public void setChromatogramSelection(IChromatogramSelection chromatogramSelectionX) {
        chromatogramSelection = chromatogramSelectionX;
    }

    public void deleteIdentifications(Shell shell, String text, boolean deleteChromatogramIdentifications, boolean deletePeakIdentifications, boolean deleteScanIdentifications) {
        IChromatogram chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogram()) != null) {
            MessageBox messageBox = new MessageBox(shell, 456);
            messageBox.setText(text);
            messageBox.setMessage("Do you really want to delete the identifications?");
            int decision = messageBox.open();
            if (64 == decision) {
                if (deleteChromatogramIdentifications) {
                    chromatogram.getTargets().clear();
                }
                if (deletePeakIdentifications) {
                    List<IPeak> peaks = ChromatogramDataSupport.getPeaks(chromatogram);
                    for (IPeak peak : peaks) {
                        peak.getTargets().clear();
                    }
                }
                if (deleteScanIdentifications) {
                    List<IScan> scans = ChromatogramDataSupport.getIdentifiedScans(chromatogramSelection.getChromatogram());
                    for (IScan scan : scans) {
                        scan.getTargets().clear();
                    }
                }
                this.update();
            }
        }
    }

    private void update() {
        chromatogramSelection.update(true);
    }
}

