/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.core.IMeasurementInfo;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.ux.extension.ui.provider.AbstractSupplierFileEditorSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.ISupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.editors.CalibrationFileSupplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ProjectExplorerEditorSupport
extends AbstractSupplierFileEditorSupport
implements ISupplierEditorSupport {
    private static final Logger logger = Logger.getLogger(ProjectExplorerEditorSupport.class);
    private String type = "";
    private static final String DATA_EXPLORER = "Data Explorer";

    public ProjectExplorerEditorSupport(DataType dataType) {
        super(ProjectExplorerEditorSupport.getSupplier(dataType));
        this.initialize(dataType);
    }

    private static List<ISupplier> getSupplier(DataType dataType) {
        ArrayList<ISupplier> supplier = new ArrayList<ISupplier>();
        switch (dataType) {
            case CAL: {
                supplier.add(new CalibrationFileSupplier());
            }
        }
        return supplier;
    }

    private void initialize(DataType dataType) {
        switch (dataType) {
            case CAL: {
                this.type = "CAL";
                break;
            }
            default: {
                this.type = "";
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean openEditor(File file) {
        return this.openEditor(file, false);
    }

    public boolean openEditor(File file, boolean batch) {
        boolean success = false;
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(DATA_EXPLORER);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            Path path = new Path(file.getAbsolutePath());
            IFile input = project.getFile(path.lastSegment());
            input.createLink((IPath)path, 256, null);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)input);
                success = true;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return success;
    }

    public void openEditor(IMeasurement measurement) {
    }

    public void openOverview(File file) {
    }

    public void openOverview(IMeasurementInfo measurementInfo) {
    }

    public boolean openEditor(File file, ISupplier supplier) {
        return this.openEditor(file);
    }
}

