/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.charts;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.chemclipse.model.core.ISignal;
import org.eclipse.chemclipse.swt.ui.support.Fonts;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.SignalTargetReference;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetReference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.marker.AbstractBaseChartPaintListener;
import org.eclipse.swtchart.extensions.marker.IBaseChartPaintListener;

public class TargetReferenceLabelMarker
extends AbstractBaseChartPaintListener
implements IBaseChartPaintListener {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_FENCES = false;
    private final int offset;
    private static final int NO_ALPHA = 255;
    private final List<TargetLabel> identifications = new ArrayList<TargetLabel>();
    private boolean visible = true;
    private final boolean showReferenceId;
    private int rotation;
    private int detectionDepth;
    private final IPreferenceStore preferenceStore;

    public TargetReferenceLabelMarker(BaseChart baseChart, int offset, IPreferenceStore preferenceStore) {
        this(baseChart, false, offset, preferenceStore);
    }

    public TargetReferenceLabelMarker(BaseChart baseChart, boolean showReferenceId, int offset, IPreferenceStore preferenceStore) {
        super(baseChart);
        this.showReferenceId = showReferenceId;
        this.offset = offset;
        this.preferenceStore = preferenceStore;
    }

    public TargetReferenceLabelMarker(BaseChart baseChart, Collection<? extends SignalTargetReference> references, TargetDisplaySettings settings, int offset, IPreferenceStore preferenceStore) {
        this(baseChart, false, offset, preferenceStore);
        this.setData(references, settings);
    }

    public void paintControl(PaintEvent event) {
        Chart chart;
        ISeries<?> series;
        Widget widget;
        if (!this.getBaseChart().isBufferActive() && this.visible && !this.identifications.isEmpty() && (widget = event.widget) instanceof IPlotArea && (series = this.getReferenceSeries(chart = ((IPlotArea)widget).getChart())) != null) {
            IAxisSet axisSet = chart.getAxisSet();
            this.paintLabels(event.gc, axisSet.getXAxis(series.getXAxisId()), axisSet.getYAxis(series.getYAxisId()));
        }
    }

    protected ISeries<?> getReferenceSeries(Chart chart) {
        return chart.getSeriesSet().getSeries("Chromatogram");
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    /*
     * Unable to fully structure code
     */
    private void paintLabels(GC gc, IAxis xAxis, IAxis yAxis) {
        transform = new Transform(gc.getDevice());
        oldTransform = new Transform(gc.getDevice());
        gc.getTransform(oldTransform);
        fontMap = new IdentityHashMap<FontData, Font>();
        oldFont = gc.getFont();
        gc.setAlpha(255);
        identityMatrix = new float[6];
        oldTransform.getElements(identityMatrix);
        try {
            activeColor = gc.getDevice().getSystemColor(2);
            inactiveColor = gc.getDevice().getSystemColor(15);
            idColor = gc.getDevice().getSystemColor(16);
            clipping = gc.getClipping();
            lastReference = null;
            collisions = 0;
            for (TargetLabel reference : this.identifications) {
                x = xAxis.getPixelCoordinate(TargetLabel.access$0(reference));
                if (!clipping.contains(x, y = yAxis.getPixelCoordinate(TargetLabel.access$2(reference)))) continue;
                if (TargetLabel.access$3(reference) != null) {
                    font = fontMap.computeIfAbsent(TargetLabel.access$3(reference), (Function<FontData, Font>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(org.eclipse.swt.graphics.GC org.eclipse.swt.graphics.FontData ), (Lorg/eclipse/swt/graphics/FontData;)Lorg/eclipse/swt/graphics/Font;)((GC)gc));
                    gc.setFont(font);
                } else {
                    gc.setFont(oldFont);
                }
                TargetLabel.access$4(reference, new LabelBounds(gc, reference));
                label = TargetLabel.access$1(reference);
                this.setTransform(transform, x, y, reference, identityMatrix);
                if (TargetLabel.access$5(reference)) {
                    gc.setForeground(activeColor);
                    gc.setBackground(activeColor);
                } else {
                    gc.setForeground(inactiveColor);
                    gc.setBackground(inactiveColor);
                }
                if (this.detectionDepth > 0) {
                    if (lastReference != null && TargetLabel.access$6(lastReference) != null) {
                        if (TargetLabel.access$6(lastReference).getCx() > TargetLabel.access$6(reference).getCx() || TargetLabel.access$6(lastReference).intersects(TargetLabel.access$6(reference))) {
                            ++collisions;
                            yoffset = TargetLabel.access$6(lastReference).offsetY(TargetLabel.access$6(reference));
                            this.setTransform(transform, Math.max((float)x, TargetLabel.access$6(lastReference).getCx()) + (float)this.offset - identityMatrix[4], (float)y - yoffset - (float)this.offset, reference, identityMatrix);
                            if (clipping.contains(Math.round(TargetLabel.access$6(reference).getTopX()), Math.round(TargetLabel.access$6(reference).getTopY()))) {
                                gc.setTransform(oldTransform);
                                this.drawHandle(gc, reference, x, y, true, identityMatrix);
                            } else {
                                this.setTransform(transform, x, y, reference, identityMatrix);
                                xoffset = TargetLabel.access$6(lastReference).offsetX(TargetLabel.access$6(reference));
                                this.setTransform(transform, (float)x + xoffset + (float)this.offset, y, reference, identityMatrix);
                                gc.setTransform(oldTransform);
                                this.drawHandle(gc, reference, x, y, false, identityMatrix);
                            }
                        } else {
                            collisions = 0;
                        }
                    }
                    if (collisions > this.detectionDepth) {
                        lastReference = null;
                        collisions = 0;
                    } else {
                        lastReference = reference;
                    }
                }
                gc.setTransform(transform);
                gc.drawText(label, 0, 0, true);
                if (TargetLabel.access$7(reference) == null || !TargetLabel.access$5(reference)) continue;
                gc.setForeground(idColor);
                gc.drawText(TargetLabel.access$7(reference), LabelBounds.access$0(TargetLabel.access$6(reference)) + this.offset / 2, 0, true);
            }
            for (TargetLabel reference : this.identifications) {
                if (TargetLabel.access$6(reference) == null) continue;
                TargetLabel.access$6(reference).dispose();
                TargetLabel.access$4(reference, null);
            }
        }
        finally {
            gc.setTransform(oldTransform);
            oldTransform.dispose();
            gc.setFont(oldFont);
            ** for (font : fontMap.values())
        }
lbl-1000:
        // 1 sources

        {
            font.dispose();
            continue;
        }
lbl78:
        // 1 sources

        transform.dispose();
    }

    private int setTransform(Transform transform, float x, float y, TargetLabel reference, float[] identityMatrix) {
        int h = reference.bounds.height;
        transform.setElements(identityMatrix[0], identityMatrix[1], identityMatrix[2], identityMatrix[3], identityMatrix[4], identityMatrix[5]);
        transform.translate(x, y - (float)this.offset);
        transform.rotate((float)(-this.rotation));
        transform.translate(0.0f, (float)(-h / 2));
        reference.bounds.setTransform(transform);
        return h;
    }

    private void drawHandle(GC gc, TargetLabel reference, int x, int y, boolean upsideDown, float[] identityMatrix) {
        float dy;
        float dx;
        float cx = reference.bounds.getCx() - identityMatrix[4];
        float cy = reference.bounds.getCy() - identityMatrix[5] + (float)this.offset;
        gc.setLineStyle(4);
        Path path = new Path(gc.getDevice());
        if (upsideDown) {
            dx = (cx - (float)x) / 2.0f;
            dy = this.offset / 2;
        } else {
            dy = ((float)y - cy) / 2.0f;
            dx = this.offset / 2;
        }
        path.moveTo((float)x, (float)y);
        path.lineTo((float)x + dx, (float)y - dy);
        path.lineTo(cx - dx, cy + dy);
        path.lineTo(cx, cy);
        gc.drawPath(path);
        path.dispose();
        int ow = 2;
        gc.fillOval(x - ow, y - ow, ow * 2, ow * 2);
        gc.fillOval((int)(cx - (float)ow), (int)(cy - (float)ow), ow * 2, ow * 2);
    }

    public <X> void setRawData(Collection<X> data, int rotation, int detectionDepth, Predicate<X> visibilityFilter, Function<X, String> labelSupplier, Function<X, FontData> fontSupplier, Function<X, org.eclipse.chemclipse.numeric.core.Point> pointSupplier) {
        this.rotation = rotation;
        this.detectionDepth = detectionDepth;
        this.identifications.clear();
        for (X generic : data) {
            String label;
            if (!visibilityFilter.test(generic) || (label = labelSupplier.apply(generic)) == null || label.isEmpty()) continue;
            org.eclipse.chemclipse.numeric.core.Point point = pointSupplier.apply(generic);
            TargetLabel targetLabel = new TargetLabel(label, null, fontSupplier.apply(generic), true, point.getX(), point.getY());
            this.identifications.add(targetLabel);
        }
        Collections.sort(this.identifications, (o1, o2) -> Double.compare(((TargetLabel)o1).x, ((TargetLabel)o2).x));
    }

    public Predicate<TargetReference> setData(Collection<? extends SignalTargetReference> identifications, TargetDisplaySettings settings) {
        return this.setData(identifications, settings, always -> true);
    }

    public Predicate<TargetReference> setData(Collection<? extends SignalTargetReference> input, TargetDisplaySettings settings, Predicate<TargetReference> activeFilter) {
        this.identifications.clear();
        Predicate<TargetReference> createVisibleFilter = SignalTargetReference.createVisibleFilter(settings);
        if (settings != null) {
            this.rotation = settings.getRotation();
            this.detectionDepth = settings.getCollisionDetectionDepth();
            TargetDisplaySettings.LibraryField field = settings.getField();
            FontData peakFontData = TargetReferenceLabelMarker.getPeakFontData(this.preferenceStore);
            FontData scanFontData = TargetReferenceLabelMarker.getScanFontData(this.preferenceStore);
            for (SignalTargetReference signalTargetReference : input) {
                String label;
                if (!createVisibleFilter.test(signalTargetReference) || (label = signalTargetReference.getTargetLabel(field)) == null || label.isEmpty()) continue;
                boolean isPeakLabel = "Peak".equals(signalTargetReference.getType());
                boolean isScanLabel = "Scan".equals(signalTargetReference.getType());
                boolean isActive = activeFilter == null || activeFilter.test(signalTargetReference);
                ISignal scan = signalTargetReference.getSignal();
                Object fd = isPeakLabel ? peakFontData : (isScanLabel ? scanFontData : null);
                TargetLabel targetLabel = new TargetLabel(label, this.showReferenceId ? signalTargetReference.getName() : null, (FontData)fd, isActive, scan.getX(), scan.getY());
                this.identifications.add(targetLabel);
            }
        }
        Collections.sort(this.identifications, (o1, o2) -> Double.compare(((TargetLabel)o1).x, ((TargetLabel)o2).x));
        return createVisibleFilter;
    }

    public static Font createPeakFont(IPreferenceStore preferenceStore, Device device) {
        String name = preferenceStore.getString("chromatogramPeakLabelFontName");
        int height = preferenceStore.getInt("chromatogramPeakLabelFontSize");
        int style = preferenceStore.getInt("chromatogramPeakLabelFontStyle");
        Point dpi = device.getDPI();
        int pointHeight = height * 72 / dpi.y;
        return new Font(device, name, pointHeight, style);
    }

    public static Font createScanFont(IPreferenceStore preferenceStore, Device device) {
        String name = preferenceStore.getString("chromatogramScanLabelFontName");
        int height = preferenceStore.getInt("chromatogramScanLabelFontSize");
        int style = preferenceStore.getInt("chromatogramScanLabelFontStyle");
        Point dpi = device.getDPI();
        int pointHeight = height * 72 / dpi.y;
        return new Font(device, name, pointHeight, style);
    }

    public static FontData getPeakFontData(IPreferenceStore preferenceStore) {
        String name = preferenceStore.getString("chromatogramPeakLabelFontName");
        int height = preferenceStore.getInt("chromatogramPeakLabelFontSize");
        int style = preferenceStore.getInt("chromatogramPeakLabelFontStyle");
        return new FontData(name, height, style);
    }

    public static FontData getScanFontData(IPreferenceStore preferenceStore) {
        String name = preferenceStore.getString("chromatogramScanLabelFontName");
        int height = preferenceStore.getInt("chromatogramScanLabelFontSize");
        int style = preferenceStore.getInt("chromatogramScanLabelFontStyle");
        return new FontData(name, height, style);
    }

    private static /* synthetic */ Font lambda$0(GC gC, FontData fd) {
        return Fonts.createDPIAwareFont((Device)gC.getDevice(), (FontData)fd);
    }

    private static final class LabelBounds {
        private final float[] pointArray = new float[10];
        private final int[] transformedPoints = new int[10];
        private final int width;
        private final int height;
        private final GC gc;
        private Region region;

        public LabelBounds(GC gc, TargetLabel label) {
            this.gc = gc;
            Point labelSize = gc.textExtent(label.label);
            this.width = labelSize.x;
            this.height = labelSize.y;
        }

        public boolean intersects(LabelBounds other) {
            if (other != null && other.region != null) {
                int i = 0;
                while (i < this.transformedPoints.length) {
                    if (other.region.contains(this.transformedPoints[i], this.transformedPoints[i + 1]) || this.region.contains(other.transformedPoints[i], other.transformedPoints[i + 1])) {
                        return true;
                    }
                    i += 2;
                }
            }
            return false;
        }

        public void dispose() {
            if (this.region != null) {
                this.region.dispose();
            }
            this.region = null;
        }

        public void setTransform(Transform transform) {
            this.pointArray[0] = 0.0f;
            this.pointArray[1] = 0.0f;
            this.pointArray[2] = this.width;
            this.pointArray[3] = 0.0f;
            this.pointArray[4] = this.width;
            this.pointArray[5] = this.height;
            this.pointArray[6] = 0.0f;
            this.pointArray[7] = this.height;
            this.pointArray[8] = 0.0f;
            this.pointArray[9] = (float)this.height / 2.0f;
            transform.transform(this.pointArray);
            int i = 0;
            while (i < this.transformedPoints.length) {
                this.transformedPoints[i] = Math.round(this.pointArray[i]);
                ++i;
            }
            if (this.region != null) {
                this.region.dispose();
            }
            this.region = new Region(this.gc.getDevice());
            this.region.add(this.transformedPoints);
        }

        public float getCx() {
            return this.pointArray[8];
        }

        public float getCy() {
            return this.pointArray[9];
        }

        public float getTopX() {
            return this.pointArray[2];
        }

        public float getTopY() {
            return this.pointArray[3];
        }

        public float getBottomX() {
            return this.pointArray[6];
        }

        public float getBottomY() {
            return this.pointArray[7];
        }

        public float getRightX() {
            return this.pointArray[4];
        }

        public float getLeftX() {
            return this.pointArray[0];
        }

        public float getLeftY() {
            return this.pointArray[1];
        }

        public float offsetX(LabelBounds other) {
            float w;
            if (this.transformedPoints[1] == this.transformedPoints[3] || this.transformedPoints[0] == this.transformedPoints[2]) {
                w = this.getRightX();
            } else {
                float x1 = this.pointArray[6];
                float y1 = this.pointArray[7];
                float x2 = this.pointArray[4];
                float y2 = this.pointArray[5];
                float dx = x2 - x1;
                float m = (y2 - y1) / dx;
                float b = (x2 * y1 - x1 * y2) / dx;
                w = Math.min((other.getLeftY() - b) / m, this.getRightX());
            }
            return w - other.getLeftX();
        }

        public float offsetY(LabelBounds other) {
            float h;
            if (other.getCx() > this.getTopX() || this.transformedPoints[0] == this.transformedPoints[2]) {
                h = this.getTopY();
            } else {
                float x = other.getBottomX();
                float x1 = this.pointArray[0];
                float y1 = this.pointArray[1];
                float x2 = this.pointArray[2];
                float y2 = this.pointArray[3];
                float dx = x2 - x1;
                float m = (y2 - y1) / dx;
                float b = (x2 * y1 - x1 * y2) / dx;
                h = Math.min(Math.max(m * x + b, this.getTopY()), this.getBottomY());
            }
            return this.getBottomY() - h + (other.getCy() - this.getCy());
        }

        public void paintBounds() {
            this.gc.setTransform(null);
            Color old_fg = this.gc.getForeground();
            Font old_font = this.gc.getFont();
            try {
                Font font = new Font(this.gc.getDevice(), "Tahoma", 8, 0);
                this.gc.setFont(font);
                this.gc.setLineStyle(2);
                this.gc.drawPolygon(this.transformedPoints);
                this.paintPoint(0, 9);
                this.paintPoint(1, 3);
                this.paintPoint(2, 5);
                this.paintPoint(3, 15);
                this.paintPoint(4, 2);
                this.gc.setLineStyle(1);
                font.dispose();
            }
            finally {
                this.gc.setFont(old_font);
                this.gc.setForeground(old_fg);
            }
        }

        private void paintPoint(int p, int color) {
            int i = p * 2;
            int x = this.transformedPoints[i];
            int y = this.transformedPoints[i + 1];
            int lw = 5;
            this.gc.setForeground(this.gc.getDevice().getSystemColor(color));
            String string = p == 4 ? "pc" : "p" + p;
            Point s = this.gc.stringExtent(string);
            if (p == 0) {
                this.gc.drawString(string, x - s.x - 5, y - s.y - 5, true);
            } else if (p == 1) {
                this.gc.drawString(string, x, y - s.y - 5, true);
            } else if (p == 2) {
                this.gc.drawString(string, x, y, true);
            } else {
                this.gc.drawString(string, x - s.x, y, true);
            }
            this.gc.drawLine(x + lw, y + lw, x - lw, y - lw);
            this.gc.drawLine(x - lw, y + lw, x + lw, y - lw);
        }

        static /* synthetic */ int access$0(LabelBounds labelBounds) {
            return labelBounds.width;
        }
    }

    private static final class TargetLabel {
        private final String label;
        private final String id;
        private final boolean isActive;
        private final double x;
        private final double y;
        private final FontData fontData;
        private LabelBounds bounds;

        public TargetLabel(String label, String id, FontData fontData, boolean isActive, double x, double y) {
            this.label = label;
            this.id = id;
            this.fontData = fontData;
            this.isActive = isActive;
            this.x = x;
            this.y = y;
        }

        static /* synthetic */ double access$2(TargetLabel targetLabel) {
            return targetLabel.y;
        }

        static /* synthetic */ FontData access$3(TargetLabel targetLabel) {
            return targetLabel.fontData;
        }

        static /* synthetic */ void access$4(TargetLabel targetLabel, LabelBounds labelBounds) {
            targetLabel.bounds = labelBounds;
        }

        static /* synthetic */ boolean access$5(TargetLabel targetLabel) {
            return targetLabel.isActive;
        }

        static /* synthetic */ String access$7(TargetLabel targetLabel) {
            return targetLabel.id;
        }
    }
}

