/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.charts;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.chemclipse.converter.scan.IScanConverterSupport;
import org.eclipse.chemclipse.model.core.IComplexSignalMeasurement;
import org.eclipse.chemclipse.model.core.ISignal;
import org.eclipse.chemclipse.model.core.PeakPosition;
import org.eclipse.chemclipse.nmr.converter.core.ScanConverterNMR;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.axisconverter.PassThroughConverter;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;

public class ChartNMR
extends LineChart {
    private static final boolean PROCESSED_AXIS_REVERSED = true;
    private IAxisScaleConverter ppmconverter;

    public ChartNMR(Composite parent, int style) {
        this(parent, style, null);
    }

    public ChartNMR(Composite parent, int style, final Supplier<IComplexSignalMeasurement<?>> measurementSupplier) {
        super(parent, style);
        this.initialize();
        if (measurementSupplier != null) {
            IChartSettings settings = this.getChartSettings();
            IScanConverterSupport converterSupport = ScanConverterNMR.getScanConverterSupport();
            List exportSupplier = converterSupport.getExportSupplier();
            for (final ISupplier supplier : exportSupplier) {
                settings.addMenuEntry(new IChartMenuEntry(){

                    public String getName() {
                        return supplier.getFilterName();
                    }

                    public String getCategory() {
                        return "Export";
                    }

                    public void execute(Shell shell, ScrollableChart scrollableChart) {
                        FileDialog fileDialog = new FileDialog(shell, 8192);
                        fileDialog.setText("NMR Export");
                        fileDialog.setFilterExtensions(new String[]{"*" + supplier.getFileExtension()});
                        fileDialog.setFilterNames(new String[]{supplier.getFilterName()});
                        String pathname = fileDialog.open();
                        if (pathname != null) {
                            final File file = new File(pathname);
                            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                            try {
                                dialog.run(true, true, new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                        IProcessingInfo export = ScanConverterNMR.export((File)file, (IComplexSignalMeasurement)((IComplexSignalMeasurement)measurementSupplier.get()), (String)supplier.getId(), (IProgressMonitor)monitor);
                                        ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)export);
                                    }
                                });
                            }
                            catch (InvocationTargetException e) {
                                ProcessingInfoViewSupport.updateProcessingInfoError((String)"NMR Export", (String)"Export failed", (Throwable)e.getCause());
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }
    }

    public void modifyChart(boolean rawData) {
        if (rawData) {
            this.modifyRaw();
        } else {
            this.modifyProcessed();
        }
    }

    public void setPPMconverter(IAxisScaleConverter ppmconverter) {
        this.ppmconverter = ppmconverter;
    }

    private void initialize() {
        this.modifyProcessed();
    }

    private void modifyRaw() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(false);
        chartSettings.getRangeRestriction().setZeroX(false);
        chartSettings.getRangeRestriction().setZeroY(false);
        this.setPrimaryAxisSetRaw(chartSettings);
        this.addSecondaryAxisSetRaw(chartSettings);
        this.applySettings(chartSettings);
    }

    private void setPrimaryAxisSetRaw(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("scan");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsX.setPosition(IAxis.Position.Primary);
        primaryAxisSettingsX.setVisible(false);
        primaryAxisSettingsX.setReversed(false);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Intensity");
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
    }

    private void addSecondaryAxisSetRaw(IChartSettings chartSettings) {
        this.deleteSecondaryAxes(chartSettings);
        SecondaryAxisSettings secondaryAxisSettingsX1 = new SecondaryAxisSettings("t1 (sec)", (IAxisScaleConverter)new PassThroughConverter());
        secondaryAxisSettingsX1.setPosition(IAxis.Position.Primary);
        secondaryAxisSettingsX1.setDecimalFormat(new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsX1.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX1);
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings("Relative Intensity [%]", (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }

    private void modifyProcessed() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(false);
        chartSettings.getRangeRestriction().setZeroX(false);
        chartSettings.getRangeRestriction().setZeroY(false);
        this.setPrimaryAxisSetProcessed(chartSettings);
        this.addSecondaryAxisSetProcessed(chartSettings);
        this.applySettings(chartSettings);
    }

    private void setPrimaryAxisSetProcessed(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("Frequency [Hz]");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsX.setVisible(true);
        primaryAxisSettingsX.setReversed(true);
        if (this.ppmconverter == null) {
            primaryAxisSettingsX.setPosition(IAxis.Position.Primary);
            primaryAxisSettingsX.setGridLineStyle(LineStyle.DASH);
        } else {
            primaryAxisSettingsX.setPosition(IAxis.Position.Secondary);
            primaryAxisSettingsX.setGridLineStyle(LineStyle.NONE);
        }
        primaryAxisSettingsX.setExtraSpaceTitle(10);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Intensity");
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsY.setGridLineStyle(LineStyle.NONE);
    }

    private void addSecondaryAxisSetProcessed(IChartSettings chartSettings) {
        this.deleteSecondaryAxes(chartSettings);
        if (this.ppmconverter != null) {
            SecondaryAxisSettings secondaryAxisSettingsX1 = new SecondaryAxisSettings("ppm", this.ppmconverter);
            secondaryAxisSettingsX1.setPosition(IAxis.Position.Primary);
            secondaryAxisSettingsX1.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
            secondaryAxisSettingsX1.setColor(DisplayUtils.getDisplay().getSystemColor(2));
            secondaryAxisSettingsX1.setVisible(true);
            secondaryAxisSettingsX1.setReversed(true);
            secondaryAxisSettingsX1.setExtraSpaceTitle(10);
            chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX1);
        }
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings("Relative Intensity [%]", (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }

    private void deleteSecondaryAxes(IChartSettings chartSettings) {
        chartSettings.getSecondaryAxisSettingsListX().clear();
        chartSettings.getSecondaryAxisSettingsListY().clear();
    }

    public static ISeriesData createSignalSeries(String id, Collection<? extends ISignal> signals) {
        return ChartNMR.createSignalSeries(id, signals, 0.0, 0.0);
    }

    public static ISeriesData createPeakSeries(String id, List<? extends ISignal> signals, Iterable<PeakPosition> iterable, double yOffset, double xOffset) {
        List list = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
        int size = list.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int index = 0;
        for (PeakPosition position : list) {
            int maximum = position.getPeakMaximum();
            if (maximum > -1) {
                ISignal signal = signals.get(maximum);
                xSeries[index] = signal.getX() + xOffset;
                ySeries[index] = signal.getY() + yOffset;
            } else {
                xSeries[index] = Double.NaN;
                ySeries[index] = Double.NaN;
            }
            ++index;
        }
        return new SeriesData(xSeries, ySeries, id);
    }

    public static ISeriesData createSignalSeries(String id, Collection<? extends ISignal> signals, double yOffset, double xOffset) {
        int size = signals.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int index = 0;
        for (ISignal iSignal : signals) {
            xSeries[index] = iSignal.getX() + xOffset;
            ySeries[index] = iSignal.getY() + yOffset;
            ++index;
        }
        return new SeriesData(xSeries, ySeries, id);
    }
}

