/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.filter.IMeasurementFilter;
import org.eclipse.chemclipse.model.supplier.IMeasurementFilterProcessTypeSupplier;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.actions.AbstractFilterAction;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class IMeasurementFilterAction
extends AbstractFilterAction<IMeasurementFilter<?>, Collection<? extends IMeasurement>> {
    private Collection<? extends IMeasurement> measurements;
    private ProcessSupplierContext processTypeSupport;
    private Object settings;

    public IMeasurementFilterAction(IMeasurementFilter<?> filter, Collection<? extends IMeasurement> measurements, Consumer<Collection<? extends IMeasurement>> resultConsumer, ProcessSupplierContext processTypeSupport) {
        super(filter, resultConsumer);
        this.measurements = measurements;
        this.processTypeSupport = processTypeSupport;
        this.setEnabled(filter.acceptsIMeasurements(measurements));
    }

    @Override
    public void executeAction(Shell shell) {
        IProcessSupplier processSupplier;
        if (this.processTypeSupport != null && (processSupplier = this.processTypeSupport.getSupplier(IMeasurementFilterProcessTypeSupplier.getID((IMeasurementFilter)((IMeasurementFilter)this.filter)))) != null) {
            try {
                ProcessorPreferences preferences = SettingsWizard.getSettings(shell, SettingsWizard.getWorkspacePreferences(processSupplier));
                if (preferences == null) {
                    return;
                }
                if (!preferences.isUseSystemDefaults()) {
                    this.settings = preferences.getSettings();
                }
            }
            catch (IOException e) {
                ProcessingInfoViewSupport.updateProcessingInfoError((String)((IMeasurementFilter)this.filter).getName(), (String)"Can't process settings", (Throwable)e);
            }
            catch (CancellationException e) {
                return;
            }
        }
        super.executeAction(shell);
    }

    @Override
    protected Collection<? extends IMeasurement> computeResult(MessageConsumer messageConsumer, IProgressMonitor progressMonitor) {
        return (Collection)((IMeasurementFilter)this.filter).filterIMeasurements(this.measurements, this.settings, Function.identity(), messageConsumer, progressMonitor);
    }
}

