/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.l10n.Messages;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.ui.wizards.IExtendedWizardPage;
import org.eclipse.chemclipse.support.ui.wizards.IFileWizard;
import org.eclipse.chemclipse.support.ui.wizards.IWizardElements;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractWizard
extends Wizard
implements IFileWizard {
    private static final Logger logger = Logger.getLogger(AbstractWizard.class);
    private ISelection selection;
    private IWizardElements wizardElements;
    private Set<IExtendedWizardPage> wizardPages;

    public AbstractWizard(IWizardElements wizardElements) {
        this.setNeedsProgressMonitor(true);
        this.wizardElements = wizardElements;
        this.wizardPages = new HashSet<IExtendedWizardPage>();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void addPage(IWizardPage page) {
        if (page instanceof IExtendedWizardPage) {
            this.wizardPages.add((IExtendedWizardPage)page);
        }
        super.addPage(page);
    }

    public boolean canFinish() {
        Iterator<IExtendedWizardPage> iterator = this.wizardPages.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().canFinish()) continue;
            return false;
        }
        return true;
    }

    public IWizardElements getWizardElements() {
        return this.wizardElements;
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AbstractWizard.this.doFinish(monitor);
                }
                catch (CoreException e) {
                    logger.warn((Object)e);
                }
            }
        };
        Messages messages = SupportMessages.INSTANCE();
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (InterruptedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)messages.getMessage("processingError", new String[0]), (String)messages.getMessage("processingProcessInterrupted", new String[0]));
            return false;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)messages.getMessage("processingError", new String[0]), (String)messages.getMessage("processingSomethingWrong", new String[0]));
            return false;
        }
        return true;
    }
}

