/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.fieldeditors;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FloatFieldEditor
extends StringFieldEditor {
    private float minValue = -3.4028235E38f;
    private float maxValue = Float.MAX_VALUE;

    public FloatFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public FloatFieldEditor(String name, String labelText, float minValue, float maxValue, Composite parent) {
        super(name, labelText, parent);
        if (minValue >= maxValue) {
            throw new IllegalArgumentException("Invalid min/max values: " + minValue + ", " + maxValue);
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    protected boolean checkState() {
        block5: {
            Text textControl = this.getTextControl();
            if (textControl == null) {
                this.clearErrorMessage();
                return true;
            }
            if (!this.getTextControl().isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            String stringValue = textControl.getText();
            Float value = Float.valueOf(stringValue);
            if (!(value.floatValue() >= this.minValue) || !(value.floatValue() <= this.maxValue)) break block5;
            this.clearErrorMessage();
            return true;
        }
        try {
            this.setAndShowErrorMessage();
        }
        catch (NumberFormatException e) {
            this.setAndShowErrorMessage();
        }
        return false;
    }

    protected void doLoad() {
        Text textControl = this.getTextControl();
        if (textControl != null) {
            Float value = Float.valueOf(this.getPreferenceStore().getFloat(this.getPreferenceName()));
            textControl.setText(value.toString());
        }
        super.doLoad();
    }

    public boolean isValid() {
        this.refreshValidState();
        return !this.getTextControl().isEnabled() || super.isValid();
    }

    protected void refreshValidState() {
        super.refreshValidState();
    }

    protected boolean doCheckState() {
        return super.doCheckState();
    }

    protected void doLoadDefault() {
        Text textControl = this.getTextControl();
        if (textControl != null) {
            Float value = Float.valueOf(this.getPreferenceStore().getDefaultFloat(this.getPreferenceName()));
            textControl.setText(value.toString());
        }
        this.valueChanged();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
    }

    protected void doStore() {
        Text textControl = this.getTextControl();
        if (textControl != null && textControl.isEnabled()) {
            float value = Float.valueOf(textControl.getText()).floatValue();
            this.getPreferenceStore().setValue(this.getPreferenceName(), value);
        }
    }

    private void setAndShowErrorMessage() {
        this.showErrorMessage("Allowed range (MIN = " + this.minValue + ")(MAX = " + this.maxValue + ")");
    }
}

