/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import java.util.Arrays;
import org.eclipse.chemclipse.support.ui.preferences.editors.QuantInputValidator;
import org.eclipse.chemclipse.support.util.QuantReferencesListUtil;
import org.eclipse.chemclipse.support.util.TargetListUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class QuantReferencesListEditor
extends ListEditor {
    public QuantReferencesListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.initialize(parent);
    }

    protected String createList(String[] items) {
        QuantReferencesListUtil listUtil = new QuantReferencesListUtil();
        return listUtil.createList(items);
    }

    protected String getNewInputObject() {
        List list = this.getList();
        InputDialog dialog = new InputDialog(this.getShell(), "Quantitation Reference", "You can create a new quantitation reference here.", "Styrene", (IInputValidator)new QuantInputValidator(list.getItems()));
        dialog.create();
        if (dialog.open() == 0) {
            String target = dialog.getValue();
            return this.addInstrument(target, list);
        }
        return null;
    }

    private void initialize(Composite parent) {
        Composite composite = this.getButtonBoxControl(parent);
        Button button = new Button(composite, 8);
        button.setText("Clear References");
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = QuantReferencesListEditor.this.getList();
                if (list != null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageBox messageBox = new MessageBox(shell, 448);
                    messageBox.setText("Delete Quantitation Reference(s)");
                    messageBox.setMessage("Would you like to delete the selected reference(s) from the list?");
                    int decision = messageBox.open();
                    if (decision == 64) {
                        list.removeAll();
                    }
                }
            }
        });
    }

    private String addInstrument(String target, List list) {
        String[] items = list.getItems();
        if (!this.itemExistsInList(target, items)) {
            return target;
        }
        return null;
    }

    private boolean itemExistsInList(String target, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(target)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String[] parseString(String stringList) {
        TargetListUtil targetListUtil = new TargetListUtil();
        Object[] targets = targetListUtil.parseString(stringList);
        Arrays.sort(targets);
        return targets;
    }
}

