/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import java.util.Collection;
import java.util.function.BiPredicate;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.xxd.model.filter.peaks.ShapeFilterSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class ShapeFilter
implements IPeakFilter<ShapeFilterSettings> {
    private static BiPredicate<RangeContainer, Double> LEADING_SMALLER_THAN_LIMIT_COMPARATOR = (container, shapeSetting) -> container.leading < shapeSetting;
    private static BiPredicate<RangeContainer, Double> TAILING_GREATER_THAN_LIMIT_COMPARATOR = (container, shapeSetting) -> container.tailing > shapeSetting;
    private static BiPredicate<RangeContainer, RangeContainer> VALUES_WITHIN_RANGE_COMPARATOR_R = (container, shapeSetting) -> shapeSetting.isWithinRange((RangeContainer)container);

    public String getName() {
        return "Shape Filter";
    }

    public String getDescription() {
        return "Filter peaks by leading and tailing";
    }

    public Class<ShapeFilterSettings> getConfigClass() {
        return ShapeFilterSettings.class;
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        return true;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, ShapeFilterSettings configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        Collection read = listener.read();
        if (configuration == null) {
            configuration = (ShapeFilterSettings)this.createConfiguration(read);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)read.size());
        ShapePredicate<?> predicate = ShapeFilter.getPredicate(configuration);
        for (IPeak peak : read) {
            ShapeFilter.processPeakSuperRange(configuration, listener, peak, predicate);
            subMonitor.worked(1);
        }
    }

    private static ShapePredicate<?> getPredicate(ShapeFilterSettings configuration) {
        switch (configuration.getFilterSelectionCriterion()) {
            case LEADING_SMALLER_THAN_LIMIT: {
                return new ShapePredicate<Double>(LEADING_SMALLER_THAN_LIMIT_COMPARATOR, configuration.getLeadingValue());
            }
            case TAILING_GREATER_THAN_LIMIT: {
                return new ShapePredicate<Double>(TAILING_GREATER_THAN_LIMIT_COMPARATOR, configuration.getTailingValue());
            }
            case VALUES_WITHIN_RANGE: {
                return new ShapePredicate<RangeContainer>(VALUES_WITHIN_RANGE_COMPARATOR_R, new RangeContainer(configuration.getLeadingValue(), configuration.getTailingValue()));
            }
        }
        throw new IllegalArgumentException("Unsupported Peak Filter Selection Criterion!");
    }

    private static <X extends IPeak> void processPeakSuperRange(ShapeFilterSettings configuration, CRUDListener<X, IPeakModel> listener, X peak, ShapePredicate<?> predicate) {
        RangeContainer container = new RangeContainer(peak.getPeakModel().getLeading(), peak.getPeakModel().getTailing());
        switch (configuration.getFilterTreatmentOption()) {
            case ENABLE_PEAK: {
                if (!predicate.test(container)) break;
                peak.setActiveForAnalysis(true);
                listener.updated(peak);
                break;
            }
            case DEACTIVATE_PEAK: {
                if (!predicate.test(container)) break;
                peak.setActiveForAnalysis(false);
                listener.updated(peak);
                break;
            }
            case KEEP_PEAK: {
                if (!predicate.negate().test(container)) break;
                listener.delete(peak);
                break;
            }
            case DELETE_PEAK: {
                if (!predicate.test(container)) break;
                listener.delete(peak);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Peak Filter Treatment Option!");
            }
        }
    }

    private static class RangeContainer {
        double leading = 0.0;
        double tailing = 0.0;

        public RangeContainer(double leading, double tailing) {
            this.leading = leading;
            this.tailing = tailing;
        }

        public boolean isWithinRange(RangeContainer container) {
            return this.leading >= container.leading && this.tailing <= container.tailing;
        }
    }

    private static class ShapePredicate<T> {
        private final BiPredicate<RangeContainer, T> predicate;
        private final T shapeSetting;

        public ShapePredicate(BiPredicate<RangeContainer, T> predicate, T shapeSetting) {
            this.predicate = predicate;
            this.shapeSetting = shapeSetting;
        }

        public ShapePredicate<?> negate() {
            return new ShapePredicate<T>(this.predicate.negate(), this.shapeSetting);
        }

        public boolean test(RangeContainer values) {
            boolean result = this.predicate.test(values, (RangeContainer)this.shapeSetting);
            return result;
        }
    }
}

