/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.eclipse.chemclipse.support.settings.DoubleSettingsProperty;
import org.eclipse.chemclipse.support.settings.EnumSelectionSettingProperty;
import org.eclipse.chemclipse.xxd.model.support.AsymmetrySelection;
import org.eclipse.chemclipse.xxd.model.support.TreatmentOption;

public class AsymmetryFilterSettings {
    @JsonProperty(value="As:", defaultValue="1.02")
    @JsonPropertyDescription(value="The peak asymmetry factor of a peak to be filtered accordingly.")
    @DoubleSettingsProperty(minValue=0.0, maxValue=10.0)
    private double peakAsymmetryFactor = 1.02;
    @JsonProperty(value="Peak Treatment Option:")
    @EnumSelectionSettingProperty
    private TreatmentOption filterTreatmentOption = TreatmentOption.DEACTIVATE_PEAK;
    @JsonProperty(value="Peak Selection Criterion:")
    @EnumSelectionSettingProperty
    private AsymmetrySelection filterSelectionCriterion = AsymmetrySelection.ASYMMETRY_FACTOR_GREATER_THAN_LIMIT;

    public double getPeakAsymmetryFactor() {
        return this.peakAsymmetryFactor;
    }

    public void setPeakAsymmetryFactor(double peakAsymmetryFactor) {
        this.peakAsymmetryFactor = peakAsymmetryFactor;
    }

    public TreatmentOption getFilterTreatmentOption() {
        return this.filterTreatmentOption;
    }

    public void setFilterTreatmentOption(TreatmentOption filterTreatmentOption) {
        this.filterTreatmentOption = filterTreatmentOption;
    }

    public AsymmetrySelection getFilterSelectionCriterion() {
        return this.filterSelectionCriterion;
    }

    public void setFilterSelectionCriterion(AsymmetrySelection filterSelectionCriterion) {
        this.filterSelectionCriterion = filterSelectionCriterion;
    }
}

