/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.methods;

import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;

public final class ProcessEntryProcessorPreferences<T>
implements ProcessorPreferences<T> {
    private final IProcessEntry processEntry;
    private final IProcessSupplier<T> supplier;

    public ProcessEntryProcessorPreferences(IProcessSupplier<T> supplier, IProcessEntry processEntry) {
        this.supplier = supplier;
        this.processEntry = processEntry;
    }

    @Override
    public ProcessorPreferences.DialogBehavior getDialogBehaviour() {
        return ProcessorPreferences.DialogBehavior.NONE;
    }

    @Override
    public void setAskForSettings(boolean askForSettings) {
    }

    @Override
    public void setUserSettings(String settings) {
        this.processEntry.setSettings(settings);
    }

    @Override
    public boolean isUseSystemDefaults() {
        if (this.supplier.getSettingsClass() == null) {
            return true;
        }
        String jsonSettings = this.processEntry.getSettings();
        return jsonSettings == null || jsonSettings.isEmpty() || "{}".equals(jsonSettings);
    }

    @Override
    public void setUseSystemDefaults(boolean useSystemDefaults) {
        if (useSystemDefaults) {
            this.processEntry.setSettings(null);
        }
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProcessSupplier<T> getSupplier() {
        return this.supplier;
    }

    @Override
    public String getUserSettingsAsString() {
        return this.processEntry.getSettings();
    }
}

