/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.util.Comparator;
import java.util.Set;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.viewers.Viewer;

public class PeakListTableComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IPeakMSD && e2 instanceof IPeakMSD) {
            IPeakMSD peak1 = (IPeakMSD)e1;
            IPeakModelMSD peakModel1 = peak1.getPeakModel();
            ILibraryInformation libraryInformation1 = IIdentificationTarget.getBestLibraryInformation((Set)peak1.getTargets(), (Comparator)this.targetExtendedComparator);
            IPeakMSD peak2 = (IPeakMSD)e2;
            IPeakModelMSD peakModel2 = peak2.getPeakModel();
            ILibraryInformation libraryInformation2 = IIdentificationTarget.getBestLibraryInformation((Set)peak2.getTargets(), (Comparator)this.targetExtendedComparator);
            switch (this.getPropertyIndex()) {
                case 0: {
                    sortOrder = Boolean.compare(peak2.isActiveForAnalysis(), peak1.isActiveForAnalysis());
                    break;
                }
                case 1: {
                    sortOrder = peakModel2.getRetentionTimeAtPeakMaximum() - peakModel1.getRetentionTimeAtPeakMaximum();
                    break;
                }
                case 2: {
                    sortOrder = Float.compare(peakModel2.getPeakMassSpectrum().getRetentionIndex(), peakModel1.getPeakMassSpectrum().getRetentionIndex());
                    break;
                }
                case 3: {
                    sortOrder = Double.compare(peak2.getIntegratedArea(), peak1.getIntegratedArea());
                    break;
                }
                case 4: {
                    sortOrder = peakModel2.getStartRetentionTime() - peakModel1.getStartRetentionTime();
                    break;
                }
                case 5: {
                    sortOrder = peakModel2.getStopRetentionTime() - peakModel1.getStopRetentionTime();
                    break;
                }
                case 6: {
                    sortOrder = peakModel2.getWidthByInflectionPoints() - peakModel1.getWidthByInflectionPoints();
                    break;
                }
                case 7: 
                case 8: {
                    if (!(e1 instanceof IChromatogramPeakMSD) || !(e2 instanceof IChromatogramPeakMSD)) break;
                    IChromatogramPeakMSD chromatogramPeak1 = (IChromatogramPeakMSD)e1;
                    IChromatogramPeakMSD chromatogramPeak2 = (IChromatogramPeakMSD)e2;
                    switch (this.getPropertyIndex()) {
                        case 7: {
                            sortOrder = chromatogramPeak2.getScanMax() - chromatogramPeak1.getScanMax();
                            break;
                        }
                        case 8: {
                            sortOrder = Float.compare(chromatogramPeak2.getSignalToNoiseRatio(), chromatogramPeak1.getSignalToNoiseRatio());
                        }
                    }
                    break;
                }
                case 9: {
                    sortOrder = Float.compare(peakModel2.getLeading(), peakModel1.getLeading());
                    break;
                }
                case 10: {
                    sortOrder = Float.compare(peakModel2.getTailing(), peakModel1.getTailing());
                    break;
                }
                case 11: {
                    sortOrder = peak2.getModelDescription().compareTo(peak1.getModelDescription());
                    break;
                }
                case 12: {
                    sortOrder = peak2.getSuggestedNumberOfComponents() - peak1.getSuggestedNumberOfComponents();
                    break;
                }
                case 13: {
                    if (libraryInformation1 == null || libraryInformation2 == null) break;
                    sortOrder = libraryInformation2.getName().compareTo(libraryInformation1.getName());
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

