/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods.IMethodReader;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractMethodReader
implements IMethodReader {
    private final String version;

    public AbstractMethodReader(String version) {
        this.version = version;
    }

    @Override
    public IProcessMethod convert(File file, MessageConsumer consumer, IProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                return this.readData(zipFile, file);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String streamVersion = AbstractMethodReader.readString(dataInputStream);
        if (streamVersion.equals(this.version)) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }

    private IProcessMethod readData(ZipFile zipFile, File file) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataInputStream dataInputStream = this.getDataInputStream(zipFile, "PROCESS_METHOD");){
            return this.deserialize(dataInputStream, file);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private DataInputStream getDataInputStream(ZipFile zipFile, String entryName) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory() || !(name = zipEntry.getName()).equals(entryName)) continue;
            return new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
        }
        throw new IOException("There could be found no entry given with the name: " + entryName);
    }

    protected static String readString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= length) {
            builder.append(String.valueOf(dataInputStream.readChar()));
            ++i;
        }
        return builder.toString();
    }

    protected abstract IProcessMethod deserialize(DataInputStream var1, File var2) throws IOException;

    @Override
    public IProcessMethod convert(InputStream stream, String nameHint, MessageConsumer consumer, IProgressMonitor monitor) throws IOException {
        return null;
    }
}

