/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.arw.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.csd.converter.io.AbstractChromatogramCSDReader;
import org.eclipse.chemclipse.csd.converter.supplier.arw.io.support.ChromatogramArrayReader;
import org.eclipse.chemclipse.csd.converter.supplier.arw.model.VendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.arw.model.VendorScan;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader
extends AbstractChromatogramCSDReader {
    private static final Logger logger = Logger.getLogger(ChromatogramReader.class);
    private static final Pattern scanPattern = Pattern.compile("(.*)(\t)(.*)");

    public IChromatogramCSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        return this.readChromatogram(file, monitor);
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        return this.readChromatogram(file, monitor);
    }

    private IChromatogramCSD readChromatogram(File file, IProgressMonitor monitor) throws IOException {
        VendorChromatogram chromatogram = new VendorChromatogram();
        chromatogram.setFile(file);
        chromatogram.setConverterId("");
        ChromatogramArrayReader in = new ChromatogramArrayReader(file);
        String input = in.readBytesAsString(in.getLength());
        Matcher matcher = scanPattern.matcher(input);
        while (matcher.find()) {
            String retentionTimeInMinutes = matcher.group(1).replace(",", ".");
            String abundance = matcher.group(3).replace(",", ".");
            try {
                int retentionTime = (int)(Double.valueOf(retentionTimeInMinutes) * 60000.0);
                float totalSignal = Float.valueOf(abundance).floatValue();
                VendorScan scan = new VendorScan();
                scan.setRetentionTime(retentionTime);
                scan.setTotalSignal(totalSignal);
                chromatogram.addScan((IScan)scan);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
        }
        this.calculateScanIntervalAndDelay(chromatogram, monitor);
        return chromatogram;
    }

    private void calculateScanIntervalAndDelay(IChromatogramCSD chromatogram, IProgressMonitor monitor) {
        int scanInterval = chromatogram.getStopRetentionTime() / chromatogram.getNumberOfScans();
        int scanDelay = chromatogram.getStartRetentionTime() - scanInterval;
        scanDelay = scanDelay < 0 ? 0 : scanDelay;
        chromatogram.setScanInterval(scanInterval);
        chromatogram.setScanDelay(scanDelay);
    }
}

