/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.baselinesubtract.core;

import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;

public class ChromatogramSubtractor {
    public void perform(IChromatogram<?> chromatogramMaster, IChromatogram<?> chromatogramSubtract) {
        if (chromatogramMaster != null && chromatogramSubtract != null) {
            int startRetentionTime = chromatogramMaster.getStartRetentionTime();
            int stopRetentionTime = chromatogramMaster.getStopRetentionTime();
            this.perform(chromatogramMaster, chromatogramSubtract, startRetentionTime, stopRetentionTime);
        }
    }

    public void perform(IChromatogram<?> chromatogramMaster, IChromatogram<?> chromatogramSubtract, int startRetentionTime, int stopRetentionTime) {
        if (chromatogramMaster != null && chromatogramSubtract != null) {
            int startScan = chromatogramMaster.getScanNumber(startRetentionTime);
            int stopScan = chromatogramMaster.getScanNumber(stopRetentionTime);
            int i = startScan;
            while (i <= stopScan) {
                int scanNumberSubtract;
                IScan scanSubtract;
                IScan scanMaster = chromatogramMaster.getScan(i);
                if (scanMaster != null && (scanSubtract = chromatogramSubtract.getScan(scanNumberSubtract = chromatogramSubtract.getScanNumber(scanMaster.getRetentionTime()))) != null) {
                    float totalSignalMaster = scanMaster.getTotalSignal();
                    float totalSignalSubstract = scanSubtract.getTotalSignal();
                    float totalSignal = totalSignalMaster - totalSignalSubstract;
                    if (scanMaster instanceof IScanMSD) {
                        if (totalSignal > 0.0f) {
                            scanMaster.adjustTotalSignal(totalSignal);
                        } else {
                            IScanMSD scanMSD = (IScanMSD)scanMaster;
                            scanMSD.removeAllIons();
                        }
                    } else {
                        scanMaster.adjustTotalSignal(totalSignal);
                    }
                }
                ++i;
            }
        }
    }
}

