/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.Activator;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.BaselineDetectorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.MassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.PeakFilterSettings;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_ITERATIONS = "iterations";
    public static final int DEF_ITERATIONS = 100;
    public static final int MIN_ITERATIONS = 5;
    public static final int MAX_ITERATIONS = 2000;
    public static final String P_WINDOW_SIZE = "windowSize";
    public static final String DEF_WINDOW_SIZE = WindowSize.WIDTH_7.toString();
    public static final String P_MAGNIFICATION_FACTOR = "magnificationFactor";
    public static final double DEF_MAGNIFICATION_FACTOR = 1.0;
    public static final double MIN_MAGNIFICATION_FACTOR = 0.01;
    public static final double MAX_MAGNIFICATION_FACTOR = 5.0;
    public static final String P_TRANSITIONS = "transitions";
    public static final int DEF_TRANSITIONS = 1;
    public static final int MIN_TRANSITIONS = 1;
    public static final int MAX_TRANSITIONS = 100;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_ITERATIONS, Integer.toString(100));
        defaultValues.put(P_MAGNIFICATION_FACTOR, Double.toString(1.0));
        defaultValues.put(P_TRANSITIONS, Integer.toString(1));
        defaultValues.put(P_WINDOW_SIZE, DEF_WINDOW_SIZE);
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static BaselineDetectorSettings getBaselineDetectorSettings() {
        BaselineDetectorSettings settings = new BaselineDetectorSettings();
        settings.setIterations(PreferenceSupplier.getIterations());
        settings.setWindowSize(PreferenceSupplier.getWindowSize());
        return settings;
    }

    public static PeakFilterSettings getPeakFilterSettings() {
        PeakFilterSettings settings = new PeakFilterSettings();
        settings.setIterations(PreferenceSupplier.getIterations());
        settings.setMagnificationFactor(PreferenceSupplier.getMagnificationFactor());
        settings.setTransitions(PreferenceSupplier.getTransitions());
        return settings;
    }

    public static MassSpectrumFilterSettings getMassSpectrumFilterSettings() {
        MassSpectrumFilterSettings settings = new MassSpectrumFilterSettings();
        settings.setIterations(PreferenceSupplier.getIterations());
        settings.setMagnificationFactor(PreferenceSupplier.getMagnificationFactor());
        settings.setTransitions(PreferenceSupplier.getTransitions());
        return settings;
    }

    public static int getIterations() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_ITERATIONS, 100);
    }

    public static WindowSize getWindowSize() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        String size = WindowSize.getAdjustedSetting((String)preferences.get(P_WINDOW_SIZE, DEF_WINDOW_SIZE));
        return WindowSize.valueOf((String)size);
    }

    public static double getMagnificationFactor() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getDouble(P_MAGNIFICATION_FACTOR, 1.0);
    }

    public static int getTransitions() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_TRANSITIONS, 1);
    }
}

