/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class MassSpectrumImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(MassSpectrumImportRunnable.class);
    private File file;
    private IMassSpectra massSpectra;

    public MassSpectrumImportRunnable(File file) {
        this.file = file;
    }

    public IMassSpectra getMassSpectra() {
        return this.massSpectra;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Mass Spectrum", -1);
                IProcessingInfo processingInfo = MassSpectrumConverter.convert((File)this.file, (IProgressMonitor)monitor);
                this.massSpectra = (IMassSpectra)processingInfo.getProcessingResult(IMassSpectra.class);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

