/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.exceptions.NoMassSpectrumConverterAvailableException;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.notifier.MassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.support.MassSpectrumFileSupport;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.support.MassSpectrumImportRunnable;
import org.eclipse.chemclipse.ux.extension.msd.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.msd.ui.swt.IMassSpectrumChart;
import org.eclipse.chemclipse.ux.extension.msd.ui.swt.MassSpectrumChartCentroid;
import org.eclipse.chemclipse.ux.extension.msd.ui.swt.MassSpectrumChartProfile;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChemClipseEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MassSpectrumEditor
implements IChemClipseEditor {
    public static final String ID = "org.eclipse.chemclipse.ux.extension.msd.ui.part.massSpectrumEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.msd.ui/org.eclipse.chemclipse.ux.extension.msd.ui.editors.MassSpectrumEditor";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/massSpectrumFile.gif";
    public static final String TOOLTIP = "Mass Spectrum - Detector Type: MSD";
    private static final Logger logger = Logger.getLogger(MassSpectrumEditor.class);
    @Inject
    private MPart part;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    private File massSpectrumFile;
    private IMassSpectra massSpectra;
    private IScanMSD massSpectrum;
    private ArrayList<EventHandler> registeredEventHandler;
    private IMassSpectrumChart massSpectrumChart;
    private List<Object> objects = new ArrayList<Object>();

    @PostConstruct
    private void createControl(Composite parent) {
        this.loadMassSpectra();
        this.createPages(parent);
        this.registeredEventHandler = new ArrayList();
        this.registerEvents();
    }

    @Focus
    public void setFocus() {
        if (this.massSpectrum != null) {
            this.eventBroker.post("scan/msd/update/selection", (Object)this.massSpectrum);
            MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)this.massSpectrum, (boolean)true);
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.eventBroker.post("scan/xxd/unload/selection", null);
        if (this.modelService != null) {
            MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            partStack.getChildren().remove(this.part);
        }
        System.gc();
    }

    @Persist
    public boolean save() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(DisplayUtils.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Save Mass Spectra", -1);
                    try {
                        MassSpectrumEditor.this.saveMassSpectra(monitor, DisplayUtils.getShell());
                    }
                    catch (NoMassSpectrumConverterAvailableException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            return this.saveAs();
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
            return false;
        }
        return true;
    }

    private void saveMassSpectra(IProgressMonitor monitor, Shell shell) throws NoMassSpectrumConverterAvailableException {
        if (this.massSpectrumFile != null && this.massSpectra != null && shell != null) {
            String converterId = this.massSpectra.getConverterId();
            if (converterId != null && !converterId.equals("")) {
                monitor.subTask("Save Mass Spectrum");
                IProcessingInfo processingInfo = MassSpectrumConverter.convert((File)this.massSpectrumFile, (IMassSpectra)this.massSpectra, (boolean)false, (String)converterId, (IProgressMonitor)monitor);
                try {
                    processingInfo.getProcessingResult(File.class);
                    this.dirtyable.setDirty(false);
                }
                catch (TypeCastException e) {
                    logger.warn((Object)e);
                }
            } else {
                throw new NoMassSpectrumConverterAvailableException();
            }
        }
    }

    public boolean saveAs() {
        boolean saveSuccessful = false;
        if (this.massSpectra != null) {
            try {
                saveSuccessful = MassSpectrumFileSupport.saveMassSpectra((IMassSpectra)this.massSpectra);
                this.dirtyable.setDirty(!saveSuccessful);
            }
            catch (NoConverterAvailableException e) {
                logger.warn((Object)e);
            }
        }
        return saveSuccessful;
    }

    private void loadMassSpectra() {
        try {
            Object object = this.part.getObject();
            if (object instanceof Map) {
                Map map = (Map)object;
                File file = new File((String)map.get("File"));
                boolean batch = (Boolean)map.get("Batch");
                this.importMassSpectrum(file, batch);
            } else if (object instanceof String) {
                File file = new File((String)object);
                this.importMassSpectrum(file, true);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    private void importMassSpectrum(File file, boolean batch) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException, ChromatogramIsNullException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(DisplayUtils.getShell());
        MassSpectrumImportRunnable runnable = new MassSpectrumImportRunnable(file);
        try {
            boolean fork = !batch;
            dialog.run(fork, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.dirtyable.setDirty(true);
        this.massSpectra = runnable.getMassSpectra();
        this.massSpectrumFile = file;
    }

    private void createPages(Composite parent) {
        if (this.massSpectra != null && this.massSpectra.getMassSpectrum(1) != null) {
            this.createMassSpectrumPage(parent);
        } else {
            this.createErrorMessagePage(parent);
        }
    }

    private void createMassSpectrumPage(Composite parent) {
        ILibraryInformation libraryInformation;
        String name = "".equals(this.massSpectra.getName()) ? "NoName" : this.massSpectra.getName();
        this.massSpectrum = this.massSpectra.getMassSpectrum(1);
        if (this.massSpectrum instanceof IVendorMassSpectrum) {
            name = ((IVendorMassSpectrum)this.massSpectrum).getName();
        } else if (this.massSpectrum instanceof IRegularLibraryMassSpectrum && (libraryInformation = ((IRegularLibraryMassSpectrum)this.massSpectrum).getLibraryInformation()) != null) {
            name = libraryInformation.getName();
        }
        this.part.setLabel(name);
        boolean isProfile = this.massSpectrum instanceof IRegularMassSpectrum ? ((IRegularMassSpectrum)this.massSpectrum).getMassSpectrumType() == 1 : PreferenceSupplier.useProfileMassSpectrumView();
        this.massSpectrumChart = isProfile ? new MassSpectrumChartProfile(parent, 0) : new MassSpectrumChartCentroid(parent, 0);
        this.massSpectrumChart.update(this.massSpectrum);
    }

    private void createErrorMessagePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Label label = new Label(composite, 0);
        label.setText("The mass spectrum couldn't be loaded.");
    }

    public void registerEvent(String topic, String property) {
        this.registerEvent(topic, new String[]{property});
    }

    public void registerEvent(String topic, String[] properties) {
        if (this.eventBroker != null) {
            this.registeredEventHandler.add(this.registerEventHandler(this.eventBroker, topic, properties));
        }
    }

    private EventHandler registerEventHandler(IEventBroker eventBroker, final String topic, final String[] properties) {
        EventHandler eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    MassSpectrumEditor.this.objects.clear();
                    String[] stringArray = properties;
                    int n = properties.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String property = stringArray[n2];
                        Object object = event.getProperty(property);
                        MassSpectrumEditor.this.objects.add(object);
                        ++n2;
                    }
                    MassSpectrumEditor.this.update(topic);
                }
                catch (Exception e) {
                    logger.warn((Object)(e + "\t" + event));
                }
            }
        };
        eventBroker.subscribe(topic, eventHandler);
        return eventHandler;
    }

    private void update(String topic) {
        if (this.massSpectrumChart.isVisible()) {
            this.updateObjects(this.objects, topic);
        }
    }

    public void registerEvents() {
        this.registerEvent("scan/msd/update/selection", "org.eclipse.e4.data");
    }

    public void updateObjects(List<Object> objects, String topic) {
        Object object;
        if (objects.size() == 1 && (object = objects.get(0)) instanceof IScanMSD && object != this.massSpectrum) {
            IScanMSD massSpectrum = (IScanMSD)object;
            this.massSpectrumChart.update(massSpectrum);
        }
    }
}

