/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IScanRange;

public class ChromatogramAnalysisSegment
implements IAnalysisSegment {
    private final IScanRange range;
    private final IChromatogram<?> chromatogram;
    private final Collection<? extends IAnalysisSegment> childs;

    public ChromatogramAnalysisSegment(IScanRange range, IChromatogram<?> chromatogram, Collection<? extends IAnalysisSegment> childs) {
        this.range = range;
        this.chromatogram = chromatogram;
        this.childs = childs;
    }

    @Override
    public Collection<? extends IAnalysisSegment> getChildSegments() {
        if (this.childs == null) {
            return Collections.emptyList();
        }
        return this.childs;
    }

    public IChromatogram<?> getChromatogram() {
        return this.chromatogram;
    }

    @Override
    public int getStartScan() {
        int startScan = this.range.getStartScan();
        if (startScan < 1) {
            return 1;
        }
        return startScan;
    }

    @Override
    public int getStopScan() {
        int stopScan = this.range.getStopScan();
        if (stopScan < this.getStartScan()) {
            return this.chromatogram.getNumberOfScans();
        }
        return stopScan;
    }

    @Override
    public int getStartRetentionTime() {
        return this.chromatogram.getScan(this.getStartScan()).getRetentionTime();
    }

    @Override
    public int getStopRetentionTime() {
        return this.chromatogram.getScan(this.getStopScan()).getRetentionTime();
    }
}

