/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.model.core.AbstractMeasurementInfo;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.core.IMeasurementInfo;
import org.eclipse.chemclipse.model.core.IMeasurementResult;

public abstract class AbstractMeasurement
extends AbstractMeasurementInfo
implements IMeasurement,
IMeasurementInfo {
    private static final long serialVersionUID = 3213312019738373785L;
    private transient Map<String, IMeasurementResult<?>> measurementResultsMap;

    public AbstractMeasurement() {
    }

    public AbstractMeasurement(Map<String, String> headerData) {
        super(headerData);
    }

    @Override
    public void addMeasurementResult(IMeasurementResult<?> chromatogramResult) {
        if (chromatogramResult != null) {
            this.getMeasurementResultsMap().put(chromatogramResult.getIdentifier(), chromatogramResult);
        }
    }

    @Override
    public IMeasurementResult<?> getMeasurementResult(String identifier) {
        return this.getMeasurementResultsMap().get(identifier);
    }

    @Override
    public void deleteMeasurementResult(String identifier) {
        this.getMeasurementResultsMap().remove(identifier);
    }

    @Override
    public void removeAllMeasurementResults() {
        this.getMeasurementResultsMap().clear();
    }

    @Override
    public Collection<IMeasurementResult<?>> getMeasurementResults() {
        return this.getMeasurementResultsMap().values();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ArrayList serializableResults = new ArrayList();
        for (IMeasurementResult<?> result : this.getMeasurementResultsMap().values()) {
            if (!(result instanceof Serializable)) continue;
            serializableResults.add(result);
        }
        out.writeObject(serializableResults);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        List results = (List)in.readObject();
        for (IMeasurementResult result : results) {
            this.getMeasurementResultsMap().put(result.getIdentifier(), result);
        }
    }

    public Map<String, IMeasurementResult<?>> getMeasurementResultsMap() {
        if (this.measurementResultsMap == null) {
            this.measurementResultsMap = new LinkedHashMap();
        }
        return this.measurementResultsMap;
    }
}

