/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pcr.model.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.model.exceptions.InvalidHeaderModificationException;
import org.eclipse.chemclipse.pcr.model.core.IDataModel;

public abstract class AbstractDataModel
implements IDataModel {
    private Map<String, String> data = new HashMap<String, String>();
    private Set<String> protectKeys = new HashSet<String>();

    @Override
    public void addProtectedKey(String key) {
        this.protectKeys.add(key);
    }

    @Override
    public Map<String, String> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    @Override
    public String getData(String key, String defaultValue) {
        return this.data.getOrDefault(key, defaultValue);
    }

    @Override
    public void setData(String key, String value) {
        if (key != null && value != null) {
            this.data.put(key, value);
        }
    }

    @Override
    public void removeData(String key) throws InvalidHeaderModificationException {
        if (this.protectKeys.contains(key)) {
            throw new InvalidHeaderModificationException("It's not possible to remove the following key: " + key);
        }
        this.data.remove(key);
    }
}

