/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.noise;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AnalysisSupportException;
import org.eclipse.chemclipse.model.support.AnalysisSupport;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.FilterException;
import org.eclipse.chemclipse.msd.model.noise.CalculatorSupport;
import org.eclipse.chemclipse.msd.model.noise.INoiseSegment;
import org.eclipse.chemclipse.msd.model.noise.NoiseSegment;
import org.eclipse.chemclipse.msd.model.support.CombinedMassSpectrumCalculator;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.core.runtime.IProgressMonitor;

public class Calculator {
    private static final Logger logger = Logger.getLogger(Calculator.class);
    private final CalculatorSupport calculatorSupport = new CalculatorSupport();

    public ICombinedMassSpectrum getNoiseMassSpectrum(List<ICombinedMassSpectrum> noiseMassSpectra, IMarkedIons ionsToPreserve, IProgressMonitor monitor) {
        CombinedMassSpectrumCalculator combinedMassSpectrumCalculator = new CombinedMassSpectrumCalculator();
        for (ICombinedMassSpectrum noiseMassSpectrum : noiseMassSpectra) {
            for (IIon ion : noiseMassSpectrum.getIons()) {
                combinedMassSpectrumCalculator.addIon(ion.getIon(), ion.getAbundance());
            }
        }
        return this.calculatorSupport.getNoiseMassSpectrum(combinedMassSpectrumCalculator, ionsToPreserve, monitor);
    }

    public List<INoiseSegment> getNoiseSegments(IExtractedIonSignals extractedIonSignals, IMarkedIons ionsToPreserve, int segmentWidth, IProgressMonitor monitor) throws FilterException {
        int width = segmentWidth;
        ScanRange scanRange = new ScanRange(extractedIonSignals.getStartScan(), extractedIonSignals.getStopScan());
        this.calculatorSupport.checkScanRange(scanRange, width);
        List<INoiseSegment> noiseSegments = null;
        try {
            AnalysisSupport analysisSupport = new AnalysisSupport((IScanRange)scanRange, width);
            List analysisSegments = analysisSupport.getAnalysisSegments();
            noiseSegments = this.calculateNoiseSegments(analysisSegments, extractedIonSignals, ionsToPreserve, monitor);
        }
        catch (AnalysisSupportException e) {
            logger.warn((Object)e);
        }
        return noiseSegments;
    }

    private List<INoiseSegment> calculateNoiseSegments(List<IAnalysisSegment> analysisSegments, IExtractedIonSignals extractedIonSignals, IMarkedIons ionsToPreserve, IProgressMonitor monitor) {
        int rejected = 0;
        int accepted = 0;
        ArrayList<INoiseSegment> noiseSegments = new ArrayList<INoiseSegment>();
        for (IAnalysisSegment analysisSegment : analysisSegments) {
            if (this.calculateMedianFromMean(analysisSegment, extractedIonSignals)) {
                ++accepted;
                CombinedMassSpectrumCalculator combinedMassSpectrumCalculator = this.calculatorSupport.getCombinedMassSpectrumCalculator(analysisSegment, extractedIonSignals);
                ICombinedMassSpectrum noiseMassSpectrum = this.calculatorSupport.getNoiseMassSpectrum(combinedMassSpectrumCalculator, ionsToPreserve, monitor);
                NoiseSegment noiseSegment = new NoiseSegment(analysisSegment, noiseMassSpectrum);
                noiseSegments.add(noiseSegment);
                continue;
            }
            ++rejected;
        }
        return noiseSegments;
    }

    private boolean calculateMedianFromMean(IAnalysisSegment analysisSegment, IExtractedIonSignals extractedIonSignals) {
        int size = analysisSegment.getWidth();
        if (size > 0) {
            double[] values = new double[size];
            int counter = 0;
            int scan = analysisSegment.getStartScan();
            while (scan <= analysisSegment.getStopScan()) {
                try {
                    try {
                        IExtractedIonSignal signal = extractedIonSignals.getExtractedIonSignal(scan);
                        values[counter] = signal.getTotalSignal();
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                        ++counter;
                    }
                }
                finally {
                    ++counter;
                }
            }
            double mean = Calculations.getMean((double[])values);
            return this.calculatorSupport.acceptSegment(values, mean);
        }
        return false;
    }
}

