/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.AbstractScan;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonBounds;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IonBounds;
import org.eclipse.chemclipse.msd.model.core.comparator.IonCombinedComparator;
import org.eclipse.chemclipse.msd.model.core.comparator.IonComparatorMode;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonIsNullException;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.ImmutableZeroIon;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;

public abstract class AbstractScanMSD
extends AbstractScan
implements IScanMSD {
    private static final long serialVersionUID = -5705437012632871946L;
    private static final Logger logger = Logger.getLogger(AbstractScanMSD.class);
    private static final float NORMALIZATION_BASE = 100.0f;
    private static final int LIMIT_SIM_MEASUREMENT = 10;
    private boolean isNormalized = false;
    private float normalizationBase = 0.0f;
    private List<IIon> ionsList;
    private ImmutableZeroIon immutableZeroIon;
    private IScanMSD optimizedMassSpectrum;

    public AbstractScanMSD() {
        this.init();
    }

    public AbstractScanMSD(Collection<? extends IIon> ions) {
        this.init();
        this.ionsList = new ArrayList<IIon>(ions);
    }

    public AbstractScanMSD(IScanMSD templateScan) {
        super((IScan)templateScan);
        this.init();
        this.ionsList = new ArrayList<IIon>(templateScan.getIons());
        this.isNormalized = templateScan.isNormalized();
        this.normalizationBase = templateScan.getNormalizationBase();
        this.optimizedMassSpectrum = templateScan.getOptimizedMassSpectrum();
        if (templateScan instanceof AbstractScanMSD) {
            AbstractScanMSD templateScanAbstract = (AbstractScanMSD)templateScan;
            this.immutableZeroIon = templateScanAbstract.immutableZeroIon;
        }
    }

    private void init() {
        this.createNewIonList();
        try {
            this.immutableZeroIon = new ImmutableZeroIon();
        }
        catch (AbundanceLimitExceededException | IonLimitExceededException e) {
            logger.warn(e);
        }
    }

    @Override
    public AbstractScanMSD addIons(List<IIon> ions, boolean addIntensities) {
        for (IIon ion : ions) {
            if (ion == null) continue;
            if (addIntensities) {
                this.addIon(true, ion);
                continue;
            }
            this.addIon(false, ion);
        }
        return this;
    }

    @Override
    public AbstractScanMSD addIon(boolean addIntensity, IIon ion) {
        if (ion == null) {
            logger.warn((Object)"The ion must be not null.");
            return this;
        }
        boolean addNew = true;
        for (IIon actualIon : this.ionsList) {
            if (!this.checkIon(ion, actualIon)) continue;
            if (addIntensity) {
                this.addIntensities(actualIon, ion);
                addNew = false;
                break;
            }
            if (ion.getAbundance() >= actualIon.getAbundance()) {
                this.addHigherIntensity(actualIon, ion);
                addNew = false;
                break;
            }
            addNew = false;
            break;
        }
        if (addNew) {
            this.ionsList.add(ion);
            this.setDirty(true);
        }
        return this;
    }

    @Override
    public AbstractScanMSD addIon(IIon ion, boolean checked) {
        if (checked) {
            this.addIon(ion);
        } else {
            this.ionsList.add(ion);
            this.setDirty(true);
        }
        return this;
    }

    @Override
    public AbstractScanMSD addIon(IIon ion) {
        return this.addIon(false, ion);
    }

    @Override
    public AbstractScanMSD removeIon(IIon ion) {
        this.ionsList.remove(ion);
        return this;
    }

    @Override
    public AbstractScanMSD removeAllIons() {
        this.ionsList.clear();
        return this;
    }

    @Override
    public AbstractScanMSD removeIon(int ion) {
        HashSet<Integer> ions = new HashSet<Integer>();
        ions.add(ion);
        this.removeIons(ions);
        return this;
    }

    @Override
    public AbstractScanMSD removeIons(Set<Integer> ions) {
        if (ions == null) {
            return this;
        }
        ArrayList<IIon> ionsToRemove = new ArrayList<IIon>();
        for (IIon ion : this.ionsList) {
            if (!this.removeIon(ions, ion)) continue;
            ionsToRemove.add(ion);
        }
        this.removeIonsFromMassSpectrum(ionsToRemove);
        return this;
    }

    @Override
    public AbstractScanMSD removeIons(IMarkedIons markedIons) {
        if (markedIons == null) {
            return this;
        }
        Set<Integer> nominalIons = markedIons.getIonsNominal();
        IMarkedIons.IonMarkMode mode = markedIons.getMode();
        switch (mode) {
            case INCLUDE: {
                this.removeIons((Set)nominalIons);
                break;
            }
            case EXCLUDE: {
                HashSet<Integer> removeIons = new HashSet<Integer>();
                for (IIon ion : this.ionsList) {
                    int nominal = AbstractIon.getIon(ion.getIon());
                    if (nominalIons.contains(nominal)) continue;
                    removeIons.add(nominal);
                }
                this.removeIons(removeIons);
                break;
            }
        }
        return this;
    }

    @Override
    public List<IIon> getIons() {
        return Collections.unmodifiableList(this.ionsList);
    }

    public void clearIons() {
        this.ionsList.clear();
    }

    @Override
    public float getTotalSignal(IMarkedIons markedIons) {
        float totalSignal = 0.0f;
        if (markedIons == null || markedIons.isEmpty()) {
            totalSignal = this.getTotalSignal();
        } else {
            for (IIon ion : this.ionsList) {
                if (!AbstractScanMSD.useIon(ion, markedIons)) continue;
                totalSignal += ion.getAbundance();
            }
        }
        return totalSignal;
    }

    private static boolean useIon(IIon ion, IMarkedIons filterIons) {
        Set<Integer> ionNominal = filterIons.getIonsNominal();
        switch (filterIons.getMode()) {
            case EXCLUDE: {
                return ionNominal.contains(AbstractIon.getIon(ion.getIon()));
            }
            case INCLUDE: {
                return !ionNominal.contains(AbstractIon.getIon(ion.getIon()));
            }
        }
        return true;
    }

    public float getTotalSignal() {
        float totalSignal = 0.0f;
        for (IIon ion : this.ionsList) {
            totalSignal += ion.getAbundance();
        }
        return totalSignal;
    }

    @Override
    public IExtractedIonSignal getExtractedIonSignal() {
        if (this.hasIons()) {
            IIonBounds bounds = this.getIonBounds();
            double startIon = bounds.getLowestIon().getIon();
            double stopIon = bounds.getHighestIon().getIon();
            return this.getExtractedIonSignal(startIon, stopIon);
        }
        return new ExtractedIonSignal(0.0, 0.0);
    }

    @Override
    public IExtractedIonSignal getExtractedIonSignal(double startIon, double stopIon) {
        if (this.hasIons()) {
            ExtractedIonSignal extractedIonSignal = new ExtractedIonSignal(startIon, stopIon);
            for (IIon ion : this.getIons()) {
                extractedIonSignal.setAbundance(ion);
            }
            return extractedIonSignal;
        }
        return new ExtractedIonSignal(0.0, 0.0);
    }

    @Override
    public double getBasePeak() {
        if (this.hasIons()) {
            return this.getHighestAbundance().getIon();
        }
        return 0.0;
    }

    @Override
    public float getBasePeakAbundance() {
        if (this.hasIons()) {
            return this.getHighestAbundance().getAbundance();
        }
        return 0.0f;
    }

    @Override
    public IIon getHighestAbundance() {
        if (this.hasIons()) {
            IonCombinedComparator comparator = new IonCombinedComparator(IonComparatorMode.ABUNDANCE_FIRST);
            return Collections.max(this.ionsList, comparator);
        }
        return this.immutableZeroIon;
    }

    @Override
    public IIon getHighestIon() {
        if (this.hasIons()) {
            IonCombinedComparator comparator = new IonCombinedComparator(IonComparatorMode.MZ_FIRST);
            return Collections.max(this.ionsList, comparator);
        }
        return this.immutableZeroIon;
    }

    @Override
    public IIon getLowestAbundance() {
        if (this.hasIons()) {
            IonCombinedComparator comparator = new IonCombinedComparator(IonComparatorMode.ABUNDANCE_FIRST);
            return Collections.min(this.ionsList, comparator);
        }
        return this.immutableZeroIon;
    }

    @Override
    public IIon getLowestIon() {
        if (this.hasIons()) {
            IonCombinedComparator comparator = new IonCombinedComparator(IonComparatorMode.MZ_FIRST);
            return Collections.min(this.ionsList, comparator);
        }
        return this.immutableZeroIon;
    }

    @Override
    public IIonBounds getIonBounds() {
        IIon lowest = null;
        IIon highest = null;
        if (this.hasIons()) {
            IonCombinedComparator comparator = new IonCombinedComparator(IonComparatorMode.MZ_FIRST);
            lowest = Collections.min(this.ionsList, comparator);
            highest = Collections.max(this.ionsList, comparator);
            return new IonBounds(lowest, highest);
        }
        return null;
    }

    @Override
    public int getNumberOfIons() {
        return this.ionsList.size();
    }

    @Override
    public IIon getIon(int ion) throws AbundanceLimitExceededException, IonLimitExceededException {
        if (this.hasIons()) {
            ExtractedIonSignal extractedIonSignal = new ExtractedIonSignal(ion, ion);
            for (IIon actualIon : this.ionsList) {
                extractedIonSignal.setAbundance(actualIon);
            }
            float abundance = extractedIonSignal.getAbundance(ion);
            if (abundance > 0.0f) {
                Ion defaultIon = new Ion(ion, abundance);
                return defaultIon;
            }
            return null;
        }
        return null;
    }

    @Override
    public IIon getIon(double ion) throws AbundanceLimitExceededException, IonLimitExceededException {
        if (this.hasIons()) {
            for (IIon actualIon : this.ionsList) {
                if (actualIon.getIon() != ion) continue;
                return actualIon;
            }
        }
        return new Ion(ion, 0.0f);
    }

    @Override
    public IIon getIon(double ion, int precision) throws AbundanceLimitExceededException, IonLimitExceededException {
        if (this.hasIons()) {
            for (IIon actualIon : this.ionsList) {
                double accurateIon = AbstractIon.getIon(actualIon.getIon(), precision);
                if (accurateIon != AbstractIon.getIon(ion, precision)) continue;
                return new Ion(accurateIon, actualIon.getAbundance());
            }
        }
        return new Ion(ion, 0.0f);
    }

    @Override
    public void adjustIons(float percentage) {
        if (percentage < -1.0f || percentage > 1.0f) {
            return;
        }
        if (percentage == 0.0f) {
            return;
        }
        for (IIon ion : this.ionsList) {
            float abundance = ion.getAbundance();
            abundance += abundance * percentage;
            try {
                ion.setAbundance(abundance);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    public void adjustTotalSignal(float totalSignal) {
        if (totalSignal <= 0.0f || Float.isNaN(totalSignal) || Float.isInfinite(totalSignal)) {
            return;
        }
        if (this.getTotalSignal() == 0.0f) {
            return;
        }
        float base = 100.0f;
        float correctionFactor = base / this.getTotalSignal() * totalSignal / base;
        for (IIon ion : this.ionsList) {
            float abundance = ion.getAbundance();
            abundance *= correctionFactor;
            try {
                ion.setAbundance(abundance);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    @Override
    public IScanMSD getMassSpectrum(IMarkedIons excludedIons) {
        IScanMSD massSpectrum;
        try {
            massSpectrum = this.makeDeepCopy();
            massSpectrum.removeIons(excludedIons);
        }
        catch (CloneNotSupportedException e) {
            massSpectrum = this.createNewMassSpectrum(excludedIons);
        }
        return massSpectrum;
    }

    private IScanMSD createNewMassSpectrum(IMarkedIons excludedIons) {
        if (excludedIons == null) {
            excludedIons = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
        }
        ScanMSD massSpectrum = new ScanMSD();
        Set<Integer> excludedIonsNominal = excludedIons.getIonsNominal();
        for (IIon actualIon : this.ionsList) {
            if (excludedIonsNominal.contains(actualIon.getIon())) continue;
            try {
                Ion ion = new Ion(actualIon);
                massSpectrum.addIon(ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    @Override
    public boolean hasIons() {
        return this.ionsList.size() != 0;
    }

    @Override
    public void enforceLoadScanProxy() {
    }

    @Override
    public boolean isNormalized() {
        return this.isNormalized;
    }

    @Override
    public float getNormalizationBase() {
        return this.normalizationBase;
    }

    @Override
    public IScanMSD normalize() {
        return this.normalize(100.0f);
    }

    @Override
    public IScanMSD normalize(float base) {
        IonCombinedComparator comparator;
        if (base <= 0.0f) {
            return this;
        }
        if (!this.hasIons()) {
            return this;
        }
        List<IIon> ions = this.getIons();
        double highestAbundance = Collections.max(ions, comparator = new IonCombinedComparator(IonComparatorMode.ABUNDANCE_FIRST)).getAbundance();
        if (highestAbundance == 0.0) {
            return this;
        }
        double factor = (double)base / highestAbundance;
        this.isNormalized = true;
        this.normalizationBase = base;
        for (IIon actualIon : ions) {
            float percentageAbundance = (float)(factor * (double)actualIon.getAbundance());
            try {
                actualIon.setAbundance(percentageAbundance);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return this;
    }

    @Override
    public void setOptimizedMassSpectrum(IScanMSD optimizedMassSpectrum) {
        this.optimizedMassSpectrum = optimizedMassSpectrum;
    }

    protected void setIons(Collection<? extends IIon> ions) {
        this.ionsList = new ArrayList<IIon>(ions);
    }

    @Override
    public IScanMSD getOptimizedMassSpectrum() {
        return this.optimizedMassSpectrum;
    }

    @Override
    public boolean isMeasurementSIM() {
        return this.ionsList.size() > 0 && this.ionsList.size() <= 10;
    }

    @Override
    public boolean isTandemMS() {
        int limit = this.ionsList.size() > 30 ? 30 : this.ionsList.size();
        int i = 0;
        while (i < limit) {
            IIon ion = this.ionsList.get(i);
            if (ion.getIonTransition() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isHighResolutionMS() {
        int limit;
        if (this.ionsList.size() > 3000) {
            return true;
        }
        int counterNominal = 0;
        int counterHighRes = 0;
        int size = this.ionsList.size();
        if (size <= (limit = 10)) {
            for (IIon ion : this.ionsList) {
                String[] parts = Double.toString(ion.getIon()).split("\\.");
                if (parts[1].length() <= 1) {
                    ++counterNominal;
                    continue;
                }
                ++counterHighRes;
            }
        } else {
            int modulo = size / 10;
            int i = 0;
            while (i < this.ionsList.size()) {
                if (i % modulo == 0) {
                    IIon ion = this.ionsList.get(i);
                    String[] parts = Double.toString(ion.getIon()).split("\\.");
                    if (parts[1].length() <= 1) {
                        ++counterNominal;
                    } else {
                        ++counterHighRes;
                    }
                }
                ++i;
            }
        }
        return counterHighRes > counterNominal;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractScanMSD other = (AbstractScanMSD)otherObject;
        return this.getBasePeak() == other.getBasePeak() && this.getBasePeakAbundance() == other.getBasePeakAbundance() && this.getNumberOfIons() == other.getNumberOfIons() && this.getTotalSignal() == other.getTotalSignal() && this.isNormalized() == other.isNormalized() && this.getNormalizationBase() == other.getNormalizationBase();
    }

    public int hashCode() {
        return 7 * Double.valueOf(this.getBasePeak()).hashCode() + 11 * Float.valueOf(this.getBasePeakAbundance()).hashCode() + 13 * Float.valueOf(this.getNumberOfIons()).hashCode() + 15 * Float.valueOf(this.getTotalSignal()).hashCode() + 13 * Boolean.valueOf(this.isNormalized).hashCode() + 11 * Float.valueOf(this.normalizationBase).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[basePeak=");
        builder.append(this.getBasePeak());
        builder.append(",basePeakAbundance=");
        builder.append(this.getBasePeakAbundance());
        builder.append(",numberOfIons=");
        builder.append(this.getNumberOfIons());
        builder.append(",totalSignal=");
        builder.append(this.getTotalSignal());
        builder.append(",isNormalized=");
        builder.append(this.isNormalized());
        if (this.isNormalized()) {
            builder.append(",normalizationBase=");
            builder.append(this.getNormalizationBase());
        }
        builder.append(",Ion/Abundance pairs: ");
        Iterator<IIon> iter = this.ionsList.iterator();
        while (iter.hasNext()) {
            IIon ion = iter.next();
            builder.append(ion.getIon());
            builder.append(":");
            builder.append(ion.getAbundance());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractScanMSD massSpectrum = (AbstractScanMSD)super.clone();
        massSpectrum.createNewIonList();
        return massSpectrum;
    }

    private void addIntensities(IIon firstIon, IIon secondIon) {
        try {
            firstIon.setAbundance(secondIon.getAbundance() + firstIon.getAbundance());
            this.setDirty(true);
        }
        catch (AbundanceLimitExceededException e) {
            this.setDirty(false);
        }
    }

    private void addHigherIntensity(IIon firstIon, IIon secondIon) {
        try {
            firstIon.setAbundance(secondIon.getAbundance());
            this.setDirty(true);
        }
        catch (AbundanceLimitExceededException e) {
            this.setDirty(false);
        }
    }

    private void createNewIonList() {
        this.ionsList = new ArrayList<IIon>(200);
    }

    private boolean removeIon(Set<Integer> ions, IIon actualIon) {
        boolean remove = false;
        int abstractIon = AbstractIon.getIon(actualIon.getIon());
        for (int ion : ions) {
            if (abstractIon != ion) continue;
            remove = true;
            break;
        }
        return remove;
    }

    private void removeIonsFromMassSpectrum(List<IIon> ionsToRemove) {
        assert (ionsToRemove != null) : "The ion list must not be null.";
        for (IIon ion : ionsToRemove) {
            this.ionsList.remove(ion);
        }
    }

    private boolean checkIon(IIon ion1, IIon ion2) {
        if (ion1 != null && ion2 != null && ion1.getIon() == ion2.getIon()) {
            IIonTransition ionTransition1 = ion1.getIonTransition();
            IIonTransition ionTransition2 = ion2.getIonTransition();
            if (ionTransition1 == null && ionTransition2 == null) {
                return true;
            }
            if (ionTransition1 == null) {
                return ionTransition2.equals(ionTransition1);
            }
            return ionTransition1.equals(ionTransition2);
        }
        return false;
    }
}

