/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.gson.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.peak.IPeakExportConverter;
import org.eclipse.chemclipse.msd.converter.peak.IPeakImportConverter;
import org.eclipse.chemclipse.msd.converter.supplier.gson.model.JsonPeak;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class JsonPeakConverter
implements IPeakExportConverter,
IPeakImportConverter,
IMagicNumberMatcher {
    private static final int READ_AHEAD = 500;
    private static final String WRITER_ID_V1 = String.valueOf(JsonPeakConverter.class.getName()) + "#v1";
    private static final String KEY_NAME = "name";
    private static final String KEY_PEAKS = "peaks";
    private static final String KEY_WRITER = "id";

    public IProcessingInfo<?> convert(File file, IPeaks<? extends IPeakMSD> peaks, boolean append, IProgressMonitor monitor) {
        ProcessingInfo info = new ProcessingInfo();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                JsonPeakConverter.writePeaks(peaks, outputStream, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            info.addErrorMessage("JSONPeakConverter", "Writing to file failed", (Throwable)e);
            file.delete();
        }
        return info;
    }

    public IProcessingInfo<IPeaks<?>> convert(File file, IProgressMonitor monitor) {
        ProcessingInfo info = new ProcessingInfo();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream stream = new FileInputStream(file);){
                info.setProcessingResult(JsonPeakConverter.readPeaks(stream, monitor));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            info.addErrorMessage("JSONPeakConverter", "Writing to file failed", (Throwable)e);
        }
        return info;
    }

    public static IPeaks<IPeakMSD> readPeaks(InputStream inputStream, IProgressMonitor monitor) throws IOException {
        JsonObject root;
        Throwable throwable = null;
        Object var4_4 = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new GZIPInputStream(inputStream), StandardCharsets.UTF_8);){
            root = new JsonParser().parse((Reader)reader).getAsJsonObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!WRITER_ID_V1.equals(root.get(KEY_WRITER).getAsString())) {
            return null;
        }
        final String name = root.get(KEY_NAME).getAsString();
        final ArrayList<IPeakMSD> result = new ArrayList<IPeakMSD>();
        JsonArray peakArray = root.get(KEY_PEAKS).getAsJsonArray();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)peakArray.size());
        for (JsonElement element : peakArray) {
            result.add(JsonPeak.readPeak(element));
            subMonitor.worked(1);
        }
        return new IPeaks<IPeakMSD>(){

            public String getName() {
                return name;
            }

            public List<IPeakMSD> getPeaks() {
                return Collections.unmodifiableList(result);
            }
        };
    }

    public static void writePeaks(IPeaks<? extends IPeakMSD> data, OutputStream outputStream, IProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JsonWriter json = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new GZIPOutputStream(outputStream), StandardCharsets.UTF_8));){
            json.setIndent("    ");
            json.beginObject();
            json.name(KEY_WRITER);
            json.value(WRITER_ID_V1);
            json.name(KEY_NAME);
            json.value(data.getName());
            json.name(KEY_PEAKS);
            json.beginArray();
            List peaks = data.getPeaks();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)peaks.size());
            for (IPeakMSD peak : peaks) {
                JsonPeak.writePeak(json, peak);
                subMonitor.worked(1);
            }
            json.endArray();
            json.endObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean checkFileFormat(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(file);){
                InputStreamReader reader = new InputStreamReader((InputStream)new GZIPInputStream(in), StandardCharsets.UTF_8);
                char[] buffer = new char[500];
                int read = IOUtils.read((Reader)reader, (char[])buffer);
                String string = new String(buffer, 0, read);
                return string.contains(String.valueOf('\"') + WRITER_ID_V1 + '\"');
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

