/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.model.core;

import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.AbstractChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.results.ChromatogramSegmentation;
import org.eclipse.chemclipse.model.results.NoiseSegmentMeasurementResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;

public abstract class AbstractChromatogramCSD
extends AbstractChromatogram<IChromatogramPeakCSD>
implements IChromatogramCSD {
    private static final long serialVersionUID = -1514838958855146167L;
    private INoiseCalculator noiseCalculator;

    public AbstractChromatogramCSD() {
        this.updateNoiseCalculator();
    }

    private void updateNoiseCalculator() {
        NoiseSegmentMeasurementResult noiseResult = this.getMeasurementResult(NoiseSegmentMeasurementResult.class);
        String noiseCalculatorId = noiseResult != null ? noiseResult.getNoiseCalculatorId() : PreferenceSupplier.getSelectedNoiseCalculatorId();
        this.noiseCalculator = NoiseCalculator.getNoiseCalculator((String)noiseCalculatorId);
    }

    public void recalculateTheNoiseFactor() {
        this.updateNoiseCalculator();
    }

    public float getSignalToNoiseRatio(float abundance) {
        if (this.noiseCalculator != null) {
            return this.noiseCalculator.getSignalToNoiseRatio((IChromatogram)this, abundance);
        }
        return 0.0f;
    }

    @Override
    public IScanCSD getSupplierScan(int scan) {
        IScan storedScan;
        int position = scan;
        if (position > 0 && position <= this.getScans().size() && (storedScan = (IScan)this.getScans().get(--position)) instanceof IScanCSD) {
            return (IScanCSD)storedScan;
        }
        return null;
    }

    public void fireUpdate(IChromatogramSelection chromatogramSelection) {
        if (chromatogramSelection instanceof ChromatogramSelectionCSD) {
            ((ChromatogramSelectionCSD)chromatogramSelection).update(true);
        }
    }

    public double getPeakIntegratedArea() {
        double integratedArea = 0.0;
        for (IChromatogramPeakCSD peak : this.getPeaks()) {
            integratedArea += peak.getIntegratedArea();
        }
        return integratedArea;
    }

    public <ResultType extends IMeasurementResult<?>> ResultType getMeasurementResult(Class<ResultType> type) {
        IMeasurementResult result = super.getMeasurementResult(type);
        if (result == null && type == ChromatogramSegmentation.class) {
            return (ResultType)((IMeasurementResult)type.cast(new ChromatogramSegmentation((IChromatogram)this, PreferenceSupplier.getDefaultSegmentWidth())));
        }
        return (ResultType)result;
    }

    public void addMeasurementResult(IMeasurementResult<?> chromatogramResult) {
        super.addMeasurementResult(chromatogramResult);
        if (chromatogramResult instanceof NoiseSegmentMeasurementResult) {
            this.recalculateTheNoiseFactor();
        }
    }
}

