/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.ui.runnables;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.core.support.Identifier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.INistSettings;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class MassSpectrumIdentifierGUIRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(MassSpectrumIdentifierGUIRunnable.class);
    private static final String DESCRIPTION = "NIST GUI Mass Spectrum Identifier";
    private IChromatogramSelectionMSD chromatogramSelection;

    public MassSpectrumIdentifierGUIRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            MassSpectrumIdentifierSettings identifierSettings = PreferenceSupplier.getMassSpectrumIdentifierSettings();
            IVendorMassSpectrum massSpectrum = this.chromatogramSelection.getSelectedScan();
            MassSpectra massSpectra = new MassSpectra();
            massSpectra.addMassSpectrum((IScanMSD)massSpectrum);
            try {
                Identifier identifier = new Identifier();
                identifier.openNistForMassSpectrumIdentification((IMassSpectra)massSpectra, (INistSettings)identifierSettings, monitor);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

