/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.Activator;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIon;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIons;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.WncIon;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.WncIons;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.settings.ClassifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_WNC_IONS = "wncIons";
    public static final String DEF_WNC_IONS = "water:18;nitrogen:28;carbon dioxide:44;solvent tailing:84;column bleed:207";
    public static final String ENTRY_DELIMITER = ";";
    public static final String VALUE_DELIMITER = ":";
    private static final Logger logger = Logger.getLogger(PreferenceSupplier.class);
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_WNC_IONS, DEF_WNC_IONS);
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static ClassifierSettings getClassifierSettings() {
        ClassifierSettings classifierSettings = new ClassifierSettings();
        IWncIons wncIons = PreferenceSupplier.getWNCIons();
        classifierSettings.getWNCIons().add(wncIons);
        return classifierSettings;
    }

    public static IWncIons getWNCIons() {
        String[] items;
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        WncIons ions = new WncIons();
        String preferenceEntry = preferences.get(P_WNC_IONS, DEF_WNC_IONS);
        if (preferenceEntry != "" && (items = PreferenceSupplier.parseString(preferenceEntry)).length > 0) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                try {
                    String[] values = item.split(VALUE_DELIMITER);
                    if (values.length > 1) {
                        String name = values[0];
                        Integer ion = Integer.parseInt(values[1]);
                        ions.add(new WncIon(ion, name));
                    }
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
                ++n2;
            }
        }
        return ions;
    }

    public static String[] parseString(String stringList) {
        String[] decodedArray;
        if (stringList.contains(ENTRY_DELIMITER)) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringList, ENTRY_DELIMITER);
            int arraySize = stringTokenizer.countTokens();
            decodedArray = new String[arraySize];
            int i = 0;
            while (i < arraySize) {
                decodedArray[i] = stringTokenizer.nextToken(ENTRY_DELIMITER);
                ++i;
            }
        } else {
            decodedArray = new String[]{stringList};
        }
        return decodedArray;
    }

    public static void storeWNCIons(IWncIons wncIons) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        String values = "";
        if (wncIons != null) {
            StringBuilder builder = new StringBuilder();
            ArrayList<Integer> keys = new ArrayList<Integer>(wncIons.getKeys());
            int size = keys.size();
            if (size >= 1) {
                int index = 0;
                while (index < size) {
                    int ion = (Integer)keys.get(index);
                    IWncIon wncIon = wncIons.getWNCIon(ion);
                    if (wncIon != null) {
                        builder.append(wncIon.getName());
                        builder.append(VALUE_DELIMITER);
                        builder.append(wncIon.getIon());
                        builder.append(ENTRY_DELIMITER);
                    }
                    ++index;
                }
            }
            values = builder.toString();
        }
        preferences.put(P_WNC_IONS, values);
    }
}

