/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.editors;

import java.io.File;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.SampleQuantExportCSV;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.SampleQuantExportPDF;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.SampleQuantReader;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.SampleQuantWriter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.editors.PageSampleQuant;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class EditorSampleQuant
extends MultiPageEditorPart {
    private static final Logger logger = Logger.getLogger(EditorSampleQuant.class);
    private PageSampleQuant pageSampleQuant;
    private File file;
    private boolean isDirty = false;
    private boolean initialize = true;
    private ISampleQuantReport sampleQuantReport;

    protected void createPages() {
        this.pageSampleQuant = new PageSampleQuant(this.getContainer(), this);
        int pageIndex = this.addPage((Control)this.pageSampleQuant.getControl());
        this.setPageText(pageIndex, "Sample Quant Report (*.sqr)");
        this.setDirty(true);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            SampleQuantWriter sampleQuantWriter = new SampleQuantWriter();
            sampleQuantWriter.write(this.file, this.sampleQuantReport, (IProgressMonitor)new NullProgressMonitor());
            this.setDirty(false);
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    public void doSaveAs() {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setText("Save the *.sqr report.");
        fileDialog.setFilterExtensions(new String[]{"*.sqr", "*.csv", "*.pdf"});
        fileDialog.setFilterNames(new String[]{"Sample Quant Report *.sqr", "CSV Report *.csv", "PDF Report *.pdf"});
        fileDialog.setFileName(this.file.getName());
        String reportFile = fileDialog.open();
        if (reportFile != null) {
            try {
                File file;
                String fileName = reportFile.toLowerCase();
                int filterIndex = fileDialog.getFilterIndex();
                if (filterIndex == 1) {
                    if (!fileName.endsWith(".csv")) {
                        reportFile = String.valueOf(reportFile) + ".csv";
                    }
                    file = new File(reportFile);
                    SampleQuantExportCSV sampleQuantExportCSV = new SampleQuantExportCSV();
                    sampleQuantExportCSV.write(file, this.sampleQuantReport, (IProgressMonitor)new NullProgressMonitor());
                } else if (filterIndex == 2) {
                    if (!fileName.endsWith(".pdf")) {
                        reportFile = String.valueOf(reportFile) + ".pdf";
                    }
                    file = new File(reportFile);
                    SampleQuantExportPDF sampleQuantExportPDF = new SampleQuantExportPDF();
                    sampleQuantExportPDF.write(file, this.sampleQuantReport, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    if (!fileName.endsWith(".sqr")) {
                        reportFile = String.valueOf(reportFile) + ".sqr";
                    }
                    file = new File(reportFile);
                    SampleQuantWriter sampleQuantWriter = new SampleQuantWriter();
                    sampleQuantWriter.write(file, this.sampleQuantReport, (IProgressMonitor)new NullProgressMonitor());
                    this.setDirty(false);
                }
                MessageBox messageBox = new MessageBox(shell, 2);
                messageBox.setText("Export Sample Quant Report");
                messageBox.setMessage("The report has been exported successfully.");
                messageBox.open();
            }
            catch (Exception e) {
                logger.warn((Object)e);
                MessageBox messageBox = new MessageBox(shell, 8);
                messageBox.setText("Export Sample Quant Report");
                messageBox.setMessage("Something has gone wrong while exporting the report.");
                messageBox.open();
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
        if (this.initialize) {
            this.initialize = false;
            try {
                SampleQuantReader sampleQuantReader = new SampleQuantReader();
                this.sampleQuantReport = sampleQuantReader.read(this.file, (IProgressMonitor)new NullProgressMonitor());
                this.pageSampleQuant.showData(this.sampleQuantReport);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        String fileName = input.getName();
        fileName = fileName.substring(0, fileName.length() - 4);
        this.setPartName(fileName);
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("The file could't be loaded.");
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)input;
        this.file = fileEditorInput.getFile().getLocation().toFile();
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.firePropertyChange(257);
    }
}

