/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pcr.converter.core;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.scan.IScanConverterSupport;
import org.eclipse.chemclipse.converter.scan.ScanConverterSupport;
import org.eclipse.chemclipse.converter.scan.ScanSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.pcr.converter.core.IPlateExportConverter;
import org.eclipse.chemclipse.pcr.converter.core.IPlateImportConverter;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PlateConverterPCR {
    private static final Logger logger = Logger.getLogger(PlateConverterPCR.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.pcr.converter.plateSupplier";

    private PlateConverterPCR() {
    }

    public static IProcessingInfo convert(File file, String converterId, IProgressMonitor monitor) {
        IPlateImportConverter importConverter = PlateConverterPCR.getPlateImportConverter(converterId);
        IProcessingInfo processingInfo = importConverter != null ? importConverter.convert(file, monitor) : PlateConverterPCR.getProcessingError(file);
        return processingInfo;
    }

    public static IProcessingInfo convert(File file, IProgressMonitor monitor) {
        return PlateConverterPCR.getPlate(file, false, monitor);
    }

    private static IProcessingInfo getPlate(File file, boolean overview, IProgressMonitor monitor) {
        IScanConverterSupport converterSupport = PlateConverterPCR.getScanConverterSupport();
        try {
            List availableConverterIds = converterSupport.getAvailableConverterIds(file);
            for (String converterId : availableConverterIds) {
                Object object;
                IProcessingInfo processingInfo;
                IPlateImportConverter importConverter = PlateConverterPCR.getPlateImportConverter(converterId);
                if (importConverter == null || (processingInfo = importConverter.convert(file, monitor)).hasErrorMessages() || !((object = processingInfo.getProcessingResult()) instanceof IPlate)) continue;
                return processingInfo;
            }
        }
        catch (NoConverterAvailableException e) {
            logger.info((Object)e);
        }
        return PlateConverterPCR.getProcessingError(file);
    }

    public static IProcessingInfo convert(File file, IPlate plate, String converterId, IProgressMonitor monitor) {
        IPlateExportConverter exportConverter = PlateConverterPCR.getPlateExportConverter(converterId);
        IProcessingInfo processingInfo = exportConverter != null ? exportConverter.convert(file, plate, monitor) : PlateConverterPCR.getProcessingError(file);
        return processingInfo;
    }

    private static IPlateImportConverter getPlateImportConverter(String converterId) {
        IConfigurationElement element = PlateConverterPCR.getConfigurationElement(converterId);
        IPlateImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IPlateImportConverter)element.createExecutableExtension("importConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IPlateExportConverter getPlateExportConverter(String converterId) {
        IConfigurationElement element = PlateConverterPCR.getConfigurationElement(converterId);
        IPlateExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IPlateExportConverter)element.createExecutableExtension("exportConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static IScanConverterSupport getScanConverterSupport() {
        IConfigurationElement[] extensions;
        ScanConverterSupport converterSupport = new ScanConverterSupport(DataCategory.PCR);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ScanSupplier supplier = new ScanSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid((String)supplier.getFileExtension()) && Converter.isValid((String)supplier.getFileName()) && Converter.isValid((String)supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setExportable(Boolean.valueOf(element.getAttribute("isExportable")).booleanValue());
                supplier.setImportable(Boolean.valueOf(element.getAttribute("isImportable")).booleanValue());
                supplier.setMagicNumberMatcher(PlateConverterPCR.getMagicNumberMatcher(element));
                converterSupport.add((ISupplier)supplier);
            }
            ++n2;
        }
        return converterSupport;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension("importMagicNumberMatcher");
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }

    private static IProcessingInfo getProcessingError(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage("Plate Converter", "No suitable converter was found for: " + file);
        return processingInfo;
    }
}

