/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IPieSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.CompressPieSeries;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.swtchart.model.StringArraySeriesModel;

public class PieSeries
extends Series
implements IPieSeries {
    private Chart chart;
    private StringArraySeriesModel model;

    public PieSeries(Chart chart, String id) {
        super(chart, id);
        this.chart = chart;
        this.type = ISeries.SeriesType.PIE;
        this.initialise();
        this.compressor = new CompressPieSeries();
    }

    @Override
    public Range getAdjustedRange(Axis axis, int length) {
        return null;
    }

    @Override
    public CartesianSeriesModel getDataModel() {
        return this.model;
    }

    @Override
    public String[] getLabelSeries() {
        StringArraySeriesModel stringArraySeriesModel = (StringArraySeriesModel)this.getDataModel();
        if (stringArraySeriesModel == null) {
            return null;
        }
        String[] labels = stringArraySeriesModel.getLabels();
        String[] ids = new String[labels.length];
        System.arraycopy(labels, 0, ids, 0, labels.length);
        return ids;
    }

    @Override
    public double[] getValueSeries() {
        StringArraySeriesModel stringArraySeriesModel = (StringArraySeriesModel)this.getDataModel();
        double[] values = stringArraySeriesModel.getValues();
        double[] val = new double[values.length];
        System.arraycopy(values, 0, val, 0, values.length);
        return val;
    }

    @Override
    public Color[] getColors() {
        return ((CompressPieSeries)this.compressor).getColors();
    }

    @Override
    public void setColor(String label, Color color) {
        Color[] colors = ((CompressPieSeries)this.compressor).getColors();
        String[] labels = this.getLabelSeries();
        int i = 0;
        while (i != labels.length) {
            if (labels[i] == label) {
                colors[i] = color;
                break;
            }
            ++i;
        }
        ((CompressPieSeries)this.compressor).setColors(colors);
    }

    @Override
    public void setColor(Color[] colors) {
        ((CompressPieSeries)this.compressor).setColors(colors);
    }

    @Override
    public void setSeries(String[] labels, double[] values) {
        if (labels == null || values == null) {
            SWT.error((int)4);
            return;
        }
        String[] ids = new String[labels.length];
        System.arraycopy(labels, 0, ids, 0, labels.length);
        double[] val = new double[values.length];
        System.arraycopy(values, 0, val, 0, values.length);
        StringArraySeriesModel data = new StringArraySeriesModel(ids, val);
        this.setDataModel((CartesianSeriesModel)data);
    }

    @Override
    protected void setCompressor() {
        this.compressor = new CompressPieSeries();
    }

    @Override
    protected void draw(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        this.setBothAxisRange(width, height, xAxis, yAxis);
        int xStart = xAxis.getPixelCoordinate(-1.0);
        int yStart = yAxis.getPixelCoordinate(1.0);
        int xWidth = xAxis.getPixelCoordinate(1.0) - xStart;
        int yWidth = yAxis.getPixelCoordinate(-1.0) - yStart;
        int xZero = xAxis.getPixelCoordinate(0.0);
        int yZero = yAxis.getPixelCoordinate(0.0);
        double[] values = ((CompressPieSeries)this.compressor).getValueSeries();
        Color[] colors = ((CompressPieSeries)this.compressor).getColors();
        Point[] bounds = this.getAngleBounds(values);
        gc.setLineWidth(1);
        int i = 0;
        while (i != bounds.length) {
            gc.setBackground(colors[i]);
            gc.fillArc(xStart + 1, yStart + 1, xWidth - 1, yWidth - 1, bounds[i].x, bounds[i].y);
            double xCoordinate = Math.cos(Math.toRadians(bounds[i].x));
            double yCoordinate = -1.0 * Math.sin(Math.toRadians(bounds[i].x));
            int xPixelCoordinate = xAxis.getPixelCoordinate(xCoordinate);
            int yPixelCoordinate = xAxis.getPixelCoordinate(yCoordinate);
            gc.drawLine(xZero, yZero, xPixelCoordinate, yPixelCoordinate);
            ++i;
        }
        gc.setLineWidth(2);
        gc.drawArc(xStart + 1, yStart + 1, xStart + xWidth - 1, yStart + yWidth - 1, 0, 360);
    }

    private Point[] getAngleBounds(double[] values) {
        int start = 0;
        double total = 0.0;
        double required = 0.0;
        Point[] bounds = new Point[values.length];
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            total += val;
            ++n2;
        }
        int i = 0;
        while (i != values.length) {
            int width = (int)(values[i] * 360.0 / total);
            if (width == 0) {
                width = 1;
                required -= 1.0;
            } else {
                double diff = values[i] * 360.0 / total - (double)width;
                if ((required += diff) > 0.999) {
                    ++width;
                    required -= 1.0;
                }
            }
            Point p = new Point(start, width);
            start += width;
            bounds[i] = p;
            ++i;
        }
        return bounds;
    }

    private void setBothAxisRange(int width, int height, Axis xAxis, Axis yAxis) {
        xAxis.setRange(new Range(-1.0, 1.0));
        yAxis.setRange(new Range(-1.0, 1.0));
        if (width > height) {
            if (xAxis.isHorizontalAxis()) {
                double ratio = (double)(2 * width) / (double)height;
                xAxis.setRange(new Range(-1.0, ratio - 1.0));
            } else {
                double ratio = (double)(2 * width) / (double)height;
                yAxis.setRange(new Range(-1.0, ratio - 1.0));
            }
        } else if (xAxis.isHorizontalAxis()) {
            double ratio = (double)(2 * height) / (double)width;
            yAxis.setRange(new Range(1.0 - ratio, 1.0));
        } else {
            double ratio = (double)(2 * height) / (double)width;
            xAxis.setRange(new Range(1.0 - ratio, 1.0));
        }
    }

    @Override
    public void setDataModel(CartesianSeriesModel model) {
        this.model = (StringArraySeriesModel)model;
        this.setCompressor();
        if (this.compressor instanceof CompressPieSeries) {
            ((CompressPieSeries)this.compressor).setLabelSeries(this.getLabelSeries());
            ((CompressPieSeries)this.compressor).setValueSeries(this.getValueSeries());
        }
    }

    private void initialise() {
        IAxis[] axes;
        IAxis[] iAxisArray = axes = this.chart.getAxisSet().getAxes();
        int n = axes.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.getTick().setVisible(false);
            axis.getGrid().setVisible(false);
            axis.getTitle().setVisible(false);
            ++n2;
        }
    }
}

